/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;

public class TreeBackedLighterAST
extends LighterAST {
    private final FileASTNode myRoot;

    public TreeBackedLighterAST(FileASTNode root) {
        super(root.getCharTable());
        this.myRoot = root;
    }

    @Override
    public LighterASTNode getRoot() {
        return TreeBackedLighterAST.wrap(this.myRoot);
    }

    @Override
    public LighterASTNode getParent(LighterASTNode node) {
        return TreeBackedLighterAST.wrap(((NodeWrapper)node).myNode.getTreeParent());
    }

    @Override
    public List<LighterASTNode> getChildren(LighterASTNode parent) {
        ASTNode[] children = ((NodeWrapper)parent).myNode.getChildren(null);
        if (children == null || children.length == 0) {
            return ContainerUtil.emptyList();
        }
        ArrayList<LighterASTNode> result = new ArrayList<LighterASTNode>(children.length);
        for (ASTNode child : children) {
            result.add(TreeBackedLighterAST.wrap(child));
        }
        return result;
    }

    private static LighterASTNode wrap(ASTNode node) {
        return node.getFirstChildNode() == null && node.getTextLength() > 0 ? new TokenNodeWrapper(node) : new NodeWrapper(node);
    }

    public ASTNode unwrap(LighterASTNode node) {
        return ((NodeWrapper)node).myNode;
    }

    private static class TokenNodeWrapper
    extends NodeWrapper
    implements LighterASTTokenNode {
        public TokenNodeWrapper(ASTNode node) {
            super(node);
        }

        @Override
        public CharSequence getText() {
            return this.myNode.getText();
        }

        @Override
        public String toString() {
            return "token wrapper[" + this.myNode + "]";
        }
    }

    private static class NodeWrapper
    implements LighterASTNode {
        protected final ASTNode myNode;

        public NodeWrapper(ASTNode node) {
            this.myNode = node;
        }

        @Override
        public IElementType getTokenType() {
            return this.myNode.getElementType();
        }

        @Override
        public int getStartOffset() {
            return this.myNode.getStartOffset();
        }

        @Override
        public int getEndOffset() {
            return this.myNode.getStartOffset() + this.myNode.getTextLength();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof NodeWrapper)) {
                return false;
            }
            NodeWrapper that = (NodeWrapper)o;
            return !(this.myNode != null ? !this.myNode.equals(that.myNode) : that.myNode != null);
        }

        public int hashCode() {
            return this.myNode.hashCode();
        }

        public String toString() {
            return "node wrapper[" + this.myNode + "]";
        }
    }
}

