/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.folding;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.CustomFoldingProvider;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.Stack;
import com.intellij.util.containers.hash.HashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public abstract class CustomFoldingBuilder
extends FoldingBuilderEx
implements PossiblyDumbAware {
    private CustomFoldingProvider myDefaultProvider;
    private static final RegistryValue myMaxLookupDepth = Registry.get((String)"custom.folding.max.lookup.depth");
    private static final ThreadLocal<Set<ASTNode>> ourCustomRegionElements = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final FoldingDescriptor[] buildFoldRegions(PsiElement root, Document document, boolean quick) {
        ArrayList<FoldingDescriptor> descriptors = new ArrayList<FoldingDescriptor>();
        ourCustomRegionElements.set((Set<ASTNode>)new HashSet());
        try {
            if (CustomFoldingProvider.getAllProviders().length > 0) {
                this.myDefaultProvider = null;
                ASTNode rootNode = root.getNode();
                if (rootNode != null) {
                    this.addCustomFoldingRegionsRecursively(new FoldingStack(rootNode), rootNode, descriptors, 0);
                }
            }
            this.buildLanguageFoldRegions(descriptors, root, document, quick);
        }
        finally {
            ourCustomRegionElements.set(null);
        }
        return descriptors.toArray(new FoldingDescriptor[descriptors.size()]);
    }

    @Override
    public final FoldingDescriptor[] buildFoldRegions(ASTNode node, Document document) {
        return this.buildFoldRegions(node.getPsi(), document, false);
    }

    protected abstract void buildLanguageFoldRegions(List<FoldingDescriptor> var1, PsiElement var2, Document var3, boolean var4);

    private void addCustomFoldingRegionsRecursively(FoldingStack foldingStack, ASTNode node, List<FoldingDescriptor> descriptors, int currDepth) {
        FoldingStack localFoldingStack = this.isCustomFoldingRoot(node) ? new FoldingStack(node) : foldingStack;
        for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (this.isCustomRegionStart(child)) {
                localFoldingStack.push(child);
                continue;
            }
            if (this.isCustomRegionEnd(child)) {
                if (localFoldingStack.isEmpty()) continue;
                ASTNode startNode = (ASTNode)localFoldingStack.pop();
                int startOffset = startNode.getTextRange().getStartOffset();
                TextRange range = new TextRange(startOffset, child.getTextRange().getEndOffset());
                descriptors.add(new FoldingDescriptor(startNode, range));
                Set<ASTNode> nodeSet = ourCustomRegionElements.get();
                nodeSet.add(startNode);
                nodeSet.add(child);
                continue;
            }
            if (currDepth >= myMaxLookupDepth.asInteger()) continue;
            this.addCustomFoldingRegionsRecursively(localFoldingStack, child, descriptors, currDepth + 1);
        }
    }

    @Override
    public final String getPlaceholderText(ASTNode node, TextRange range) {
        String elementText;
        CustomFoldingProvider defaultProvider;
        if (this.isCustomFoldingCandidate(node) && (defaultProvider = this.getDefaultProvider(elementText = node.getText())) != null && defaultProvider.isCustomRegionStart(elementText)) {
            return defaultProvider.getPlaceholderText(elementText);
        }
        return this.getLanguagePlaceholderText(node, range);
    }

    protected abstract String getLanguagePlaceholderText(ASTNode var1, TextRange var2);

    @Override
    public final String getPlaceholderText(ASTNode node) {
        return "...";
    }

    @Override
    public final boolean isCollapsedByDefault(ASTNode node) {
        if (this.isCustomRegionStart(node)) {
            String childText = node.getText();
            CustomFoldingProvider defaultProvider = this.getDefaultProvider(childText);
            return defaultProvider != null && defaultProvider.isCollapsedByDefault(childText);
        }
        return this.isRegionCollapsedByDefault(node);
    }

    protected abstract boolean isRegionCollapsedByDefault(ASTNode var1);

    public final boolean isCustomRegionStart(ASTNode node) {
        if (this.isCustomFoldingCandidate(node)) {
            String nodeText = node.getText();
            CustomFoldingProvider defaultProvider = this.getDefaultProvider(nodeText);
            return defaultProvider != null && defaultProvider.isCustomRegionStart(nodeText);
        }
        return false;
    }

    protected final boolean isCustomRegionEnd(ASTNode node) {
        if (this.isCustomFoldingCandidate(node)) {
            String nodeText = node.getText();
            CustomFoldingProvider defaultProvider = this.getDefaultProvider(nodeText);
            return defaultProvider != null && defaultProvider.isCustomRegionEnd(nodeText);
        }
        return false;
    }

    protected static boolean isCustomRegionElement(PsiElement element) {
        Set<ASTNode> set = ourCustomRegionElements.get();
        return set != null && element != null && set.contains(element.getNode());
    }

    private CustomFoldingProvider getDefaultProvider(String elementText) {
        if (this.myDefaultProvider == null) {
            for (CustomFoldingProvider provider : CustomFoldingProvider.getAllProviders()) {
                if (!provider.isCustomRegionStart(elementText) && !provider.isCustomRegionEnd(elementText)) continue;
                this.myDefaultProvider = provider;
            }
        }
        return this.myDefaultProvider;
    }

    protected boolean isCustomFoldingCandidate(ASTNode node) {
        return node.getPsi() instanceof PsiComment;
    }

    protected boolean isCustomFoldingRoot(ASTNode node) {
        return node.getFirstChildNode() != null;
    }

    @Override
    public boolean isDumbAware() {
        return true;
    }

    private static class FoldingStack
    extends Stack<ASTNode> {
        private final ASTNode owner;

        public FoldingStack(ASTNode owner) {
            super(1);
            this.owner = owner;
        }

        public ASTNode getOwner() {
            return this.owner;
        }
    }
}

