/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.folding;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.CustomFoldingProvider;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.LanguageFolding;
import com.intellij.lang.surroundWith.SurroundDescriptor;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;

public class CustomFoldingSurroundDescriptor
implements SurroundDescriptor {
    public static final CustomFoldingSurroundDescriptor INSTANCE = new CustomFoldingSurroundDescriptor();
    public static final CustomFoldingRegionSurrounder[] SURROUNDERS;
    private static final String DEFAULT_DESC_TEXT = "Description";

    @Override
    public PsiElement[] getElementsToSurround(PsiFile file, int startOffset, int endOffset) {
        PsiElement endElement;
        if (startOffset >= endOffset) {
            return PsiElement.EMPTY_ARRAY;
        }
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(file.getLanguage());
        if (commenter == null || commenter.getLineCommentPrefix() == null) {
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement startElement = file.findElementAt(startOffset);
        if (startElement instanceof PsiWhiteSpace) {
            startElement = startElement.getNextSibling();
        }
        if ((endElement = file.findElementAt(endOffset - 1)) instanceof PsiWhiteSpace) {
            endElement = endElement.getPrevSibling();
        }
        if (startElement != null && endElement != null && (startElement = CustomFoldingSurroundDescriptor.findClosestParentAfterLineBreak(startElement)) != null && (endElement = CustomFoldingSurroundDescriptor.findClosestParentBeforeLineBreak(endElement)) != null) {
            return CustomFoldingSurroundDescriptor.adjustRange(startElement, endElement);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    private static PsiElement[] adjustRange(PsiElement start, PsiElement end) {
        PsiElement newStart = CustomFoldingSurroundDescriptor.lowerStartElementIfNeeded(start, end);
        PsiElement newEnd = CustomFoldingSurroundDescriptor.lowerEndElementIfNeeded(start, end);
        if (newStart == null || newEnd == null) {
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement commonParent = CustomFoldingSurroundDescriptor.findCommonAncestorForWholeRange(newStart, newEnd);
        if (commonParent != null) {
            return new PsiElement[]{commonParent};
        }
        if (newStart.getParent().getFirstChild() == newStart && newStart.getFirstChild() == null) {
            newStart = newStart.getParent();
        }
        if (newEnd.getParent().getLastChild() == newEnd && newEnd.getFirstChild() == null) {
            newEnd = newEnd.getParent();
        }
        if (newStart.getParent() == newEnd.getParent()) {
            return new PsiElement[]{newStart, newEnd};
        }
        return PsiElement.EMPTY_ARRAY;
    }

    private static PsiElement lowerEndElementIfNeeded(PsiElement start, PsiElement end) {
        if (PsiTreeUtil.isAncestor(end, start, true)) {
            PsiElement lastChild;
            for (lastChild = end.getLastChild(); lastChild != null && lastChild.getParent() != start.getParent(); lastChild = lastChild.getLastChild()) {
            }
            return lastChild;
        }
        return end;
    }

    private static PsiElement lowerStartElementIfNeeded(PsiElement start, PsiElement end) {
        if (PsiTreeUtil.isAncestor(start, end, true)) {
            PsiElement firstChild;
            for (firstChild = start.getFirstChild(); firstChild != null && firstChild.getParent() != end.getParent(); firstChild = firstChild.getFirstChild()) {
            }
            return firstChild;
        }
        return start;
    }

    private static PsiElement findCommonAncestorForWholeRange(PsiElement start, PsiElement end) {
        if (start.getContainingFile() != end.getContainingFile()) {
            return null;
        }
        PsiElement parent = PsiTreeUtil.findCommonParent(start, end);
        if (parent == null) {
            return null;
        }
        TextRange parentRange = parent.getTextRange();
        if (parentRange.getStartOffset() == start.getTextRange().getStartOffset() && parentRange.getEndOffset() == end.getTextRange().getEndOffset()) {
            return parent;
        }
        return null;
    }

    private static PsiElement findClosestParentAfterLineBreak(PsiElement element) {
        for (PsiElement parent = element; parent != null && !(parent instanceof PsiFileSystemItem); parent = parent.getParent()) {
            PsiElement prev;
            for (prev = parent.getPrevSibling(); prev != null && prev.getTextLength() <= 0; prev = prev.getPrevSibling()) {
            }
            if (CustomFoldingSurroundDescriptor.firstElementInFile(parent)) {
                return parent.getContainingFile();
            }
            if (!CustomFoldingSurroundDescriptor.isWhiteSpaceWithLineFeed(prev)) continue;
            return parent;
        }
        return null;
    }

    private static boolean firstElementInFile(PsiElement element) {
        return element.getTextOffset() == 0;
    }

    private static PsiElement findClosestParentBeforeLineBreak(PsiElement element) {
        for (PsiElement parent = element; parent != null && !(parent instanceof PsiFileSystemItem); parent = parent.getParent()) {
            PsiElement next = parent.getNextSibling();
            if (CustomFoldingSurroundDescriptor.lastElementInFile(parent)) {
                return parent.getContainingFile();
            }
            if (!CustomFoldingSurroundDescriptor.isWhiteSpaceWithLineFeed(next)) continue;
            return parent;
        }
        return null;
    }

    private static boolean lastElementInFile(PsiElement element) {
        return element.getTextRange().getEndOffset() == element.getContainingFile().getTextRange().getEndOffset();
    }

    private static boolean isWhiteSpaceWithLineFeed(PsiElement element) {
        if (element == null) {
            return false;
        }
        if (element instanceof PsiWhiteSpace) {
            return element.textContains('\n');
        }
        ASTNode node = element.getNode();
        if (node == null) {
            return false;
        }
        CharSequence text = node.getChars();
        boolean lineFeedFound = false;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (!StringUtil.isWhiteSpace((char)c)) {
                return false;
            }
            lineFeedFound |= c == '\n';
        }
        return lineFeedFound;
    }

    @Override
    public Surrounder[] getSurrounders() {
        return SURROUNDERS;
    }

    @Override
    public boolean isExclusive() {
        return false;
    }

    static {
        ArrayList<CustomFoldingRegionSurrounder> surrounderList = new ArrayList<CustomFoldingRegionSurrounder>();
        for (CustomFoldingProvider provider : CustomFoldingProvider.getAllProviders()) {
            surrounderList.add(new CustomFoldingRegionSurrounder(provider));
        }
        SURROUNDERS = surrounderList.toArray(new CustomFoldingRegionSurrounder[surrounderList.size()]);
    }

    private static class CustomFoldingRegionSurrounder
    implements Surrounder {
        private final CustomFoldingProvider myProvider;

        public CustomFoldingRegionSurrounder(CustomFoldingProvider provider) {
            this.myProvider = provider;
        }

        @Override
        public String getTemplateDescription() {
            return this.myProvider.getDescription();
        }

        @Override
        public boolean isApplicable(PsiElement[] elements) {
            if (elements.length == 0) {
                return false;
            }
            if (elements[0].getContainingFile() instanceof PsiCodeFragment) {
                return false;
            }
            for (FoldingBuilder each : LanguageFolding.INSTANCE.allForLanguage(elements[0].getLanguage())) {
                if (!(each instanceof CustomFoldingBuilder)) continue;
                return true;
            }
            return false;
        }

        @Override
        public TextRange surroundElements(Project project, Editor editor, PsiElement[] elements) throws IncorrectOperationException {
            if (elements.length == 0) {
                return null;
            }
            PsiElement firstElement = elements[0];
            PsiElement lastElement = elements[elements.length - 1];
            PsiFile psiFile = firstElement.getContainingFile();
            Language language = psiFile.getLanguage();
            Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(language);
            if (commenter == null) {
                return null;
            }
            String linePrefix = commenter.getLineCommentPrefix();
            if (linePrefix == null) {
                return null;
            }
            int prefixLength = linePrefix.length();
            int startOffset = firstElement.getTextRange().getStartOffset();
            Document document = editor.getDocument();
            int startLineNumber = document.getLineNumber(startOffset);
            String startIndent = document.getText(new TextRange(document.getLineStartOffset(startLineNumber), startOffset));
            int endOffset = lastElement.getTextRange().getEndOffset();
            int delta = 0;
            TextRange rangeToSelect = new TextRange(startOffset, startOffset);
            String startText = this.myProvider.getStartString();
            int descPos = startText.indexOf("?");
            if (descPos >= 0) {
                startText = startText.replace("?", CustomFoldingSurroundDescriptor.DEFAULT_DESC_TEXT);
                rangeToSelect = new TextRange(startOffset + descPos, startOffset + descPos + CustomFoldingSurroundDescriptor.DEFAULT_DESC_TEXT.length());
            }
            String startString = linePrefix + startText + "\n" + startIndent;
            String endString = "\n" + linePrefix + this.myProvider.getEndString();
            document.insertString(endOffset, endString);
            delta += endString.length();
            document.insertString(startOffset, startString);
            rangeToSelect = rangeToSelect.shiftRight(prefixLength);
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance(project);
            documentManager.commitDocument(documentManager.getDocument(psiFile));
            CustomFoldingRegionSurrounder.adjustLineIndent(project, psiFile, language, new TextRange(endOffset + (delta += startString.length()) - endString.length(), endOffset + delta));
            CustomFoldingRegionSurrounder.adjustLineIndent(project, psiFile, language, new TextRange(startOffset, startOffset + startString.length()));
            return rangeToSelect;
        }

        private static void adjustLineIndent(Project project, PsiFile file, Language language, TextRange range) {
            CommonCodeStyleSettings formatSettings = CodeStyleSettingsManager.getSettings(project).getCommonSettings(language);
            boolean keepAtFirstCol = formatSettings.KEEP_FIRST_COLUMN_COMMENT;
            formatSettings.KEEP_FIRST_COLUMN_COMMENT = false;
            CodeStyleManager.getInstance(project).adjustLineIndent(file, range);
            formatSettings.KEEP_FIRST_COLUMN_COMMENT = keepAtFirstCol;
        }
    }
}

