/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.folding;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.LanguageFolding;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.Set;

public class FoldingDescriptor {
    public static final FoldingDescriptor[] EMPTY = new FoldingDescriptor[0];
    private final ASTNode myElement;
    private final TextRange myRange;
    private final FoldingGroup myGroup;
    private final Set<Object> myDependencies;
    private final boolean myNeverExpands;

    public FoldingDescriptor(ASTNode node, TextRange range) {
        this(node, range, null);
    }

    public FoldingDescriptor(PsiElement element, TextRange range) {
        this((ASTNode)ObjectUtils.assertNotNull((Object)element.getNode()), range, null);
    }

    public FoldingDescriptor(ASTNode node, TextRange range, FoldingGroup group) {
        this(node, range, group, Collections.emptySet());
    }

    public FoldingDescriptor(ASTNode node, TextRange range, FoldingGroup group, Set<Object> dependencies) {
        this(node, range, group, dependencies, false);
    }

    public FoldingDescriptor(ASTNode node, TextRange range, FoldingGroup group, Set<Object> dependencies, boolean neverExpands) {
        assert (range.getLength() > 0) : range + ", text: " + node.getText() + ", language = " + (Object)((Object)node.getPsi().getLanguage());
        this.myElement = node;
        this.myRange = range;
        this.myGroup = group;
        this.myDependencies = dependencies;
        assert (!this.myDependencies.contains(null));
        this.myNeverExpands = neverExpands;
    }

    public ASTNode getElement() {
        return this.myElement;
    }

    public TextRange getRange() {
        return this.myRange;
    }

    public FoldingGroup getGroup() {
        return this.myGroup;
    }

    public String getPlaceholderText() {
        PsiElement psiElement = this.myElement.getPsi();
        if (psiElement == null) {
            return null;
        }
        Language lang = psiElement.getLanguage();
        FoldingBuilder foldingBuilder = LanguageFolding.INSTANCE.forLanguage(lang);
        if (foldingBuilder != null) {
            return foldingBuilder instanceof FoldingBuilderEx ? ((FoldingBuilderEx)foldingBuilder).getPlaceholderText(this.myElement, this.myRange) : foldingBuilder.getPlaceholderText(this.myElement);
        }
        return null;
    }

    public Set<Object> getDependencies() {
        return this.myDependencies;
    }

    public boolean isNonExpandable() {
        return this.myNeverExpands;
    }

    public String toString() {
        return this.myRange + " for AST: " + this.myElement;
    }
}

