/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.lang.Language;
import com.intellij.mock.MockPsiElement;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;

public class MockPsiDirectory
extends MockPsiElement
implements PsiDirectory {
    private final PsiPackage myPackage;
    private final Project myProject;

    public MockPsiDirectory(PsiPackage aPackage, Disposable parentDisposable) {
        super(parentDisposable);
        this.myPackage = aPackage;
        this.myProject = null;
    }

    public MockPsiDirectory(Project project, Disposable parentDisposable) {
        super(parentDisposable);
        this.myProject = project;
        this.myPackage = null;
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public Project getProject() {
        return this.myProject != null ? this.myProject : super.getProject();
    }

    @Override
    public Language getLanguage() {
        return Language.ANY;
    }

    @Override
    public void checkCreateFile(String name) throws IncorrectOperationException {
        throw new IncorrectOperationException("Method checkCreateFile is not yet implemented in " + this.getClass().getName());
    }

    @Override
    public void checkCreateSubdirectory(String name) throws IncorrectOperationException {
        throw new IncorrectOperationException("Method checkCreateSubdirectory is not yet implemented in " + this.getClass().getName());
    }

    @Override
    public PsiDirectory getParent() {
        return this.getParentDirectory();
    }

    @Override
    public PsiFile createFile(String name) throws IncorrectOperationException {
        throw new IncorrectOperationException("Method createFile is not yet implemented in " + this.getClass().getName());
    }

    @Override
    public PsiFile copyFileFrom(String newName, PsiFile originalFile) throws IncorrectOperationException {
        throw new IncorrectOperationException("Method copyFileFrom is not yet implemented in " + this.getClass().getName());
    }

    @Override
    public PsiDirectory createSubdirectory(String name) throws IncorrectOperationException {
        throw new IncorrectOperationException("Method createSubdirectory is not yet implemented in " + this.getClass().getName());
    }

    @Override
    public PsiFile findFile(@NonNls String name) {
        throw new UnsupportedOperationException("Method findFile is not yet implemented in " + this.getClass().getName());
    }

    @Override
    public PsiDirectory findSubdirectory(String name) {
        throw new UnsupportedOperationException("Method findSubdirectory is not yet implemented in " + this.getClass().getName());
    }

    @Override
    public PsiFile[] getFiles() {
        throw new UnsupportedOperationException("Method getFiles is not yet implemented in " + this.getClass().getName());
    }

    @Override
    public String getName() {
        throw new UnsupportedOperationException("Method getName is not yet implemented in " + this.getClass().getName());
    }

    @Override
    public PsiDirectory getParentDirectory() {
        PsiPackage psiPackage = this.myPackage.getParentPackage();
        return psiPackage == null ? null : new MockPsiDirectory(psiPackage, (Disposable)this.getProject());
    }

    @Override
    public PsiDirectory[] getSubdirectories() {
        throw new UnsupportedOperationException("Method getSubdirectories is not yet implemented in " + this.getClass().getName());
    }

    @Override
    public VirtualFile getVirtualFile() {
        return new LightVirtualFile();
    }

    @Override
    public boolean processChildren(PsiElementProcessor<PsiFileSystemItem> processor) {
        throw new UnsupportedOperationException("Method processChildren is not yet implemented in " + this.getClass().getName());
    }

    @Override
    public PsiElement setName(String name) throws IncorrectOperationException {
        throw new IncorrectOperationException("Method setName is not yet implemented in " + this.getClass().getName());
    }

    @Override
    public void checkSetName(String name) throws IncorrectOperationException {
        throw new IncorrectOperationException("Method checkSetName is not yet implemented in " + this.getClass().getName());
    }

    @Override
    public ItemPresentation getPresentation() {
        throw new UnsupportedOperationException("Method getPresentation is not yet implemented in " + this.getClass().getName());
    }
}

