/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification;

import com.intellij.ide.BrowserUtil;
import com.intellij.notification.Notification;
import java.net.URL;
import javax.swing.event.HyperlinkEvent;

public interface NotificationListener {
    public static final NotificationListener URL_OPENING_LISTENER = new UrlOpeningListener(true);

    public void hyperlinkUpdate(Notification var1, HyperlinkEvent var2);

    public static class UrlOpeningListener
    extends Adapter {
        private final boolean myExpireNotification;

        public UrlOpeningListener(boolean expireNotification) {
            this.myExpireNotification = expireNotification;
        }

        @Override
        protected void hyperlinkActivated(Notification notification, HyperlinkEvent event) {
            URL url = event.getURL();
            if (url == null) {
                BrowserUtil.browse(event.getDescription());
            } else {
                BrowserUtil.browse(url);
            }
            if (this.myExpireNotification) {
                notification.expire();
            }
        }
    }

    public static abstract class Adapter
    implements NotificationListener {
        @Override
        public final void hyperlinkUpdate(Notification notification, HyperlinkEvent event) {
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                this.hyperlinkActivated(notification, event);
            }
        }

        protected abstract void hyperlinkActivated(Notification var1, HyperlinkEvent var2);
    }
}

