/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEventVisitor;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataContextWrapper;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.PlaceProvider;
import java.awt.event.InputEvent;
import java.util.HashMap;
import java.util.Map;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NonNls;

public class AnActionEvent
implements PlaceProvider<String> {
    private final InputEvent myInputEvent;
    private final ActionManager myActionManager;
    private final DataContext myDataContext;
    private final String myPlace;
    private final Presentation myPresentation;
    @JdkConstants.InputEventMask
    private final int myModifiers;
    private boolean myWorksInInjected;
    @NonNls
    private static final String ourInjectedPrefix = "$injected$.";
    private static final Map<String, String> ourInjectedIds = new HashMap<String, String>();

    public AnActionEvent(InputEvent inputEvent, DataContext dataContext, @NonNls String place, Presentation presentation, ActionManager actionManager, @JdkConstants.InputEventMask int modifiers) {
        this.myInputEvent = inputEvent;
        this.myActionManager = actionManager;
        this.myDataContext = dataContext;
        this.myPlace = place;
        this.myPresentation = presentation;
        this.myModifiers = modifiers;
    }

    @Deprecated
    public static AnActionEvent createFromInputEvent(AnAction action, InputEvent event, String place) {
        DataContext context = event == null ? DataManager.getInstance().getDataContext() : DataManager.getInstance().getDataContext(event.getComponent());
        return AnActionEvent.createFromAnAction(action, event, place, context);
    }

    public static AnActionEvent createFromAnAction(AnAction action, InputEvent event, String place, DataContext dataContext) {
        int modifiers = event == null ? 0 : event.getModifiers();
        Presentation presentation = action.getTemplatePresentation().clone();
        AnActionEvent anActionEvent = new AnActionEvent(event, dataContext, place, presentation, ActionManager.getInstance(), modifiers);
        anActionEvent.setInjectedContext(action.isInInjectedContext());
        return anActionEvent;
    }

    public static AnActionEvent createFromDataContext(String place, Presentation presentation, DataContext dataContext) {
        return new AnActionEvent(null, dataContext, place, presentation == null ? new Presentation() : presentation, ActionManager.getInstance(), 0);
    }

    public static AnActionEvent createFromInputEvent(InputEvent event, String place, Presentation presentation, DataContext dataContext) {
        return new AnActionEvent(event, dataContext, place, presentation, ActionManager.getInstance(), event == null ? 0 : event.getModifiers());
    }

    public InputEvent getInputEvent() {
        return this.myInputEvent;
    }

    public Project getProject() {
        return this.getData(CommonDataKeys.PROJECT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNls
    public static String injectedId(String dataId) {
        Map<String, String> map = ourInjectedIds;
        synchronized (map) {
            String injected = ourInjectedIds.get(dataId);
            if (injected == null) {
                injected = ourInjectedPrefix + dataId;
                ourInjectedIds.put(dataId, injected);
            }
            return injected;
        }
    }

    @NonNls
    public static String uninjectedId(String dataId) {
        return StringUtil.trimStart((String)dataId, (String)ourInjectedPrefix);
    }

    public static DataContext getInjectedDataContext(DataContext context) {
        return new DataContextWrapper(context){

            @Override
            public Object getData(@NonNls String dataId) {
                Object injected = super.getData(AnActionEvent.injectedId(dataId));
                if (injected != null) {
                    return injected;
                }
                return super.getData(dataId);
            }
        };
    }

    public DataContext getDataContext() {
        return this.myWorksInInjected ? AnActionEvent.getInjectedDataContext(this.myDataContext) : this.myDataContext;
    }

    public <T> T getData(DataKey<T> key) {
        return key.getData(this.getDataContext());
    }

    public <T> T getRequiredData(DataKey<T> key) {
        T data = this.getData(key);
        assert (data != null);
        return data;
    }

    @Override
    public String getPlace() {
        return this.myPlace;
    }

    public Presentation getPresentation() {
        return this.myPresentation;
    }

    @JdkConstants.InputEventMask
    public int getModifiers() {
        return this.myModifiers;
    }

    public ActionManager getActionManager() {
        return this.myActionManager;
    }

    public void setInjectedContext(boolean worksInInjected) {
        this.myWorksInInjected = worksInInjected;
    }

    public boolean isInInjectedContext() {
        return this.myWorksInInjected;
    }

    public void accept(AnActionEventVisitor visitor) {
        visitor.visitEvent(this);
    }
}

