/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import org.jetbrains.annotations.NonNls;

public class DataContextWrapper
implements DataContext,
UserDataHolder {
    private final DataContext myDelegate;
    private final UserDataHolder myDataHolder;

    public DataContextWrapper(DataContext delegate) {
        this.myDelegate = delegate;
        this.myDataHolder = delegate instanceof UserDataHolder ? (UserDataHolder)delegate : new UserDataHolderBase();
    }

    @Override
    public Object getData(@NonNls String dataId) {
        return this.myDelegate.getData(dataId);
    }

    public <T> T getUserData(Key<T> key) {
        return (T)this.myDataHolder.getUserData(key);
    }

    public <T> void putUserData(Key<T> key, T value) {
        this.myDataHolder.putUserData(key, value);
    }
}

