/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.ApplicationManager;
import java.awt.Component;

public abstract class ModalityState {
    public static final ModalityState NON_MODAL;

    public static ModalityState current() {
        return ApplicationManager.getApplication().getCurrentModalityState();
    }

    public static ModalityState any() {
        return ApplicationManager.getApplication().getAnyModalityState();
    }

    public static ModalityState stateForComponent(Component component) {
        return ApplicationManager.getApplication().getModalityStateForComponent(component);
    }

    public static ModalityState defaultModalityState() {
        return ApplicationManager.getApplication().getDefaultModalityState();
    }

    public abstract boolean dominates(ModalityState var1);

    public abstract String toString();

    static {
        try {
            Class<?> ex = Class.forName("com.intellij.openapi.application.impl.ModalityStateEx");
            NON_MODAL = (ModalityState)ex.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
    }
}

