/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.BaseActionRunnable;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;

public class RunResult<T>
extends Result<T> {
    private BaseActionRunnable<T> myActionRunnable;
    private Throwable myThrowable;

    protected RunResult() {
    }

    public RunResult(BaseActionRunnable<T> action) {
        this.myActionRunnable = action;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RunResult<T> run() {
        try {
            this.myActionRunnable.run(this);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable throwable) {
            this.myThrowable = throwable;
            if (!this.myActionRunnable.isSilentExecution()) {
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                throw new RuntimeException(this.myThrowable);
            }
        }
        finally {
            this.myActionRunnable = null;
        }
        return this;
    }

    public T getResultObject() {
        return (T)this.myResult;
    }

    public RunResult logException(Logger logger) {
        if (this.hasException()) {
            logger.error(this.myThrowable);
        }
        return this;
    }

    public RunResult<T> throwException() throws RuntimeException, Error {
        if (this.hasException()) {
            if (this.myThrowable instanceof RuntimeException) {
                throw (RuntimeException)this.myThrowable;
            }
            if (this.myThrowable instanceof Error) {
                throw (Error)this.myThrowable;
            }
            throw new RuntimeException(this.myThrowable);
        }
        return this;
    }

    public boolean hasException() {
        return this.myThrowable != null;
    }

    public Throwable getThrowable() {
        return this.myThrowable;
    }

    public void setThrowable(Exception throwable) {
        this.myThrowable = throwable;
    }
}

