/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler;

import com.intellij.CommonBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.reference.SoftReference;
import java.lang.ref.Reference;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.PropertyKey;

public class CompilerBundle {
    private static Reference<ResourceBundle> ourBundle;
    @NonNls
    private static final String BUNDLE = "messages.CompilerBundle";

    public static String message(@PropertyKey(resourceBundle="messages.CompilerBundle") String key, Object ... params) {
        return CommonBundle.message((ResourceBundle)CompilerBundle.getBundle(), (String)key, (Object[])params);
    }

    private CompilerBundle() {
    }

    public static String jdkHomeNotFoundMessage(Sdk jdk) {
        return CompilerBundle.message("javac.error.jdk.home.missing", jdk.getName(), jdk.getHomePath());
    }

    private static ResourceBundle getBundle() {
        ResourceBundle bundle = (ResourceBundle)SoftReference.dereference(ourBundle);
        if (bundle == null) {
            bundle = ResourceBundle.getBundle(BUNDLE);
            ourBundle = new java.lang.ref.SoftReference<ResourceBundle>(bundle);
        }
        return bundle;
    }
}

