/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler.util;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionToolProvider;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public abstract class InspectionValidator {
    public static final ExtensionPointName<InspectionValidator> EP_NAME = ExtensionPointName.create((String)"com.intellij.compiler.inspectionValidator");
    private final String myDescription;
    private final String myProgressIndicatorText;
    private final Class<? extends LocalInspectionTool>[] myInspectionToolClasses;

    protected InspectionValidator(String description, String progressIndicatorText, Class<? extends LocalInspectionTool> ... inspectionToolClasses) {
        this.myDescription = description;
        this.myProgressIndicatorText = progressIndicatorText;
        this.myInspectionToolClasses = inspectionToolClasses;
    }

    protected InspectionValidator(String description, String progressIndicatorText, InspectionToolProvider provider) {
        this(description, progressIndicatorText, provider.getInspectionClasses());
    }

    protected InspectionValidator(String description, String progressIndicatorText, Class<? extends InspectionToolProvider> providerClass) throws IllegalAccessException, InstantiationException {
        this(description, progressIndicatorText, providerClass.newInstance());
    }

    public abstract boolean isAvailableOnScope(CompileScope var1);

    public abstract Collection<VirtualFile> getFilesToProcess(Project var1, CompileContext var2);

    public Collection<? extends PsiElement> getDependencies(PsiFile psiFile) {
        return Collections.emptyList();
    }

    public Class<? extends LocalInspectionTool>[] getInspectionToolClasses(CompileContext context) {
        return this.myInspectionToolClasses;
    }

    public final String getDescription() {
        return this.myDescription;
    }

    public final String getProgressIndicatorText() {
        return this.myProgressIndicatorText;
    }

    public CompilerMessageCategory getCategoryByHighlightDisplayLevel(HighlightDisplayLevel severity, VirtualFile virtualFile, CompileContext context) {
        if (severity == HighlightDisplayLevel.ERROR) {
            return CompilerMessageCategory.ERROR;
        }
        if (severity == HighlightDisplayLevel.WARNING) {
            return CompilerMessageCategory.WARNING;
        }
        return CompilerMessageCategory.INFORMATION;
    }

    public Map<ProblemDescriptor, HighlightDisplayLevel> checkAdditionally(PsiFile file) {
        return Collections.emptyMap();
    }
}

