/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.util.NotNullFunction;

public class ServiceManager {
    private ServiceManager() {
    }

    public static <T> T getService(Class<T> serviceClass) {
        Object instance = ApplicationManager.getApplication().getPicoContainer().getComponentInstance((Object)serviceClass.getName());
        return (T)instance;
    }

    public static <T> T getService(Project project, Class<T> serviceClass) {
        Object instance = project.getPicoContainer().getComponentInstance((Object)serviceClass.getName());
        return (T)instance;
    }

    public static <T> NotNullLazyKey<T, Project> createLazyKey(final Class<T> serviceClass) {
        return NotNullLazyKey.create((String)("Service: " + serviceClass.getName()), (NotNullFunction)new NotNullFunction<Project, T>(){

            public T fun(Project project) {
                return ServiceManager.getService(project, serviceClass);
            }
        });
    }
}

