/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffContentUtil;
import com.intellij.openapi.diff.DocumentContent;
import com.intellij.openapi.diff.DocumentsSynchronizer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;

public class FragmentContent
extends DiffContent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.FragmentContent");
    private final DiffContent myOriginal;
    private final FileType myType;
    private final MyDocumentsSynchronizer mySynchonizer;
    public static final Key<Document> ORIGINAL_DOCUMENT = new Key("ORIGINAL_DOCUMENT");
    private final boolean myForceReadOnly;

    public FragmentContent(DiffContent original, TextRange range, Project project, VirtualFile file) {
        this(original, range, project, file, false);
    }

    public FragmentContent(DiffContent original, TextRange range, Project project, VirtualFile file, boolean forceReadOnly) {
        this(original, range, project, file != null ? DiffContentUtil.getContentType(file) : null, forceReadOnly);
    }

    public FragmentContent(DiffContent original, TextRange range, Project project, FileType fileType) {
        this(original, range, project, fileType, false);
    }

    public FragmentContent(DiffContent original, TextRange range, Project project, FileType fileType, boolean forceReadOnly) {
        RangeMarker rangeMarker = original.getDocument().createRangeMarker(range.getStartOffset(), range.getEndOffset(), true);
        rangeMarker.setGreedyToLeft(true);
        rangeMarker.setGreedyToRight(true);
        this.mySynchonizer = new MyDocumentsSynchronizer(project, rangeMarker);
        this.myOriginal = original;
        this.myType = fileType;
        this.myForceReadOnly = forceReadOnly;
    }

    public FragmentContent(DiffContent original, TextRange range, Project project) {
        this(original, range, project, (FileType)null);
    }

    private static String subText(Document document, int startOffset, int length) {
        return ((Object)document.getCharsSequence().subSequence(startOffset, startOffset + length)).toString();
    }

    @Override
    public void onAssigned(boolean isAssigned) {
        this.myOriginal.onAssigned(isAssigned);
        this.mySynchonizer.listenDocuments(isAssigned);
        super.onAssigned(isAssigned);
    }

    @Override
    public Document getDocument() {
        return this.mySynchonizer.getCopy();
    }

    @Override
    public OpenFileDescriptor getOpenFileDescriptor(int offset) {
        return this.myOriginal.getOpenFileDescriptor(offset + this.mySynchonizer.getStartOffset());
    }

    @Override
    public VirtualFile getFile() {
        return null;
    }

    @Override
    public FileType getContentType() {
        return this.myType != null ? this.myType : this.myOriginal.getContentType();
    }

    @Override
    public byte[] getBytes() throws IOException {
        return this.getDocument().getText().getBytes();
    }

    public static FragmentContent fromRangeMarker(RangeMarker rangeMarker, Project project) {
        Document document = rangeMarker.getDocument();
        VirtualFile file = FileDocumentManager.getInstance().getFile(document);
        FileType type = file.getFileType();
        return new FragmentContent((DiffContent)new DocumentContent(project, document), TextRange.create((Segment)rangeMarker), project, type);
    }

    private class MyDocumentsSynchronizer
    extends DocumentsSynchronizer {
        private final RangeMarker myRangeMarker;

        public MyDocumentsSynchronizer(Project project, RangeMarker originalRange) {
            super(project);
            this.myRangeMarker = originalRange;
        }

        public int getStartOffset() {
            return this.myRangeMarker.getStartOffset();
        }

        @Override
        protected void onOriginalChanged(DocumentEvent event, Document copy) {
            if (!this.myRangeMarker.isValid()) {
                FragmentContent.this.fireContentInvalid();
                return;
            }
            this.replaceString(copy, 0, copy.getTextLength(), FragmentContent.subText(event.getDocument(), this.myRangeMarker.getStartOffset(), this.getLength()));
        }

        @Override
        protected void beforeListenersAttached(Document original, Document copy) {
            boolean readOnly;
            boolean bl = readOnly = !copy.isWritable();
            if (readOnly) {
                copy.setReadOnly(false);
            }
            this.replaceString(copy, 0, copy.getTextLength(), FragmentContent.subText(original, this.myRangeMarker.getStartOffset(), this.getLength()));
            copy.setReadOnly(readOnly);
        }

        private int getLength() {
            return this.myRangeMarker.getEndOffset() - this.myRangeMarker.getStartOffset();
        }

        @Override
        protected Document createOriginal() {
            return this.myRangeMarker.getDocument();
        }

        @Override
        protected Document createCopy() {
            Document originalDocument = this.myRangeMarker.getDocument();
            String textInRange = ((Object)originalDocument.getCharsSequence().subSequence(this.myRangeMarker.getStartOffset(), this.myRangeMarker.getEndOffset())).toString();
            Document result = EditorFactory.getInstance().createDocument(textInRange);
            result.setReadOnly(FragmentContent.this.myForceReadOnly || !originalDocument.isWritable());
            result.putUserData(ORIGINAL_DOCUMENT, originalDocument);
            return result;
        }

        @Override
        protected void onCopyChanged(DocumentEvent event, Document original) {
            int originalOffset = event.getOffset() + this.myRangeMarker.getStartOffset();
            LOG.assertTrue(originalOffset >= 0);
            if (!original.isWritable()) {
                return;
            }
            String newText = FragmentContent.subText(event.getDocument(), event.getOffset(), event.getNewLength());
            int originalEnd = originalOffset + event.getOldLength();
            this.replaceString(original, originalOffset, originalEnd, newText);
        }
    }
}

