/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.impl.string.DiffString;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.LineSeparator;
import com.intellij.util.SystemProperties;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class SimpleContent
extends DiffContent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.SimpleContent");
    private final byte[] myOriginalBytes;
    private final String myOriginalText;
    private final LineSeparators myLineSeparators = new LineSeparators();
    private final Document myDocument;
    private final FileType myType;
    private Charset myCharset;
    private byte[] myBOM;

    public SimpleContent(String text) {
        this(text, null);
    }

    public SimpleContent(String text, FileType type) {
        this(text, type, EditorFactory.getInstance());
    }

    public SimpleContent(String text, FileType type, EditorFactory f) {
        this.myOriginalBytes = text.getBytes();
        this.myOriginalText = this.myLineSeparators.correctText(text);
        this.myDocument = f.createDocument(this.myOriginalText);
        this.setReadOnly(true);
        this.myType = type;
    }

    public static SimpleContent createEmpty() {
        SimpleContent content = new SimpleContent("");
        content.setIsEmpty(true);
        return content;
    }

    public void setReadOnly(boolean readOnly) {
        this.myDocument.setReadOnly(readOnly);
    }

    public String getText() {
        return this.myLineSeparators.restoreText(this.myDocument.getText());
    }

    @Override
    public Document getDocument() {
        return this.myDocument;
    }

    @Override
    public OpenFileDescriptor getOpenFileDescriptor(int offset) {
        return null;
    }

    @Override
    public VirtualFile getFile() {
        return null;
    }

    @Override
    public FileType getContentType() {
        return this.myType;
    }

    @Override
    public byte[] getBytes() {
        String currentText = this.getText();
        if (this.myOriginalText.equals(this.myDocument.getText()) && this.myCharset == null) {
            return this.myOriginalBytes;
        }
        if (this.myCharset != null) {
            ByteBuffer buffer = this.myCharset.encode(currentText).compact();
            int bomLength = this.myBOM != null ? this.myBOM.length : 0;
            int encodedLength = buffer.position();
            byte[] result = new byte[encodedLength + bomLength];
            if (bomLength > 0) {
                System.arraycopy(this.myBOM, 0, result, 0, bomLength);
            }
            buffer.position(0);
            buffer.get(result, bomLength, encodedLength);
            return result;
        }
        return currentText.getBytes();
    }

    @Override
    public LineSeparator getLineSeparator() {
        return LineSeparator.fromString((String)this.myLineSeparators.mySeparator);
    }

    public Charset getCharset() {
        return this.myCharset;
    }

    public void setCharset(Charset charset) {
        this.myCharset = charset;
    }

    public static SimpleContent forFileContent(String text, String fileName) {
        FileType fileType = fileName != null ? FileTypeManager.getInstance().getFileTypeByFileName(fileName) : null;
        return new SimpleContent(text, fileType);
    }

    public static SimpleContent fromBytes(byte[] bytes, String charset, FileType fileType) throws UnsupportedEncodingException {
        if (charset == null) {
            charset = CharsetToolkit.getDefaultSystemCharset().name();
        }
        return new SimpleContent(new String(bytes, charset), fileType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DiffContent fromIoFile(File file, String charset, FileType fileType) throws IOException {
        if (file.isDirectory()) {
            throw new IllegalArgumentException(file.toString());
        }
        if (fileType == null) {
            fileType = FileTypeManager.getInstance().getFileTypeByFileName(file.getName());
        }
        BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));
        try {
            byte[] bytes = new byte[(int)file.length()];
            int bytesRead = stream.read(bytes, 0, bytes.length);
            LOG.assertTrue(file.length() == (long)bytesRead);
            SimpleContent simpleContent = SimpleContent.fromBytes(bytes, charset, fileType);
            return simpleContent;
        }
        finally {
            stream.close();
        }
    }

    public void setBOM(byte[] BOM) {
        this.myBOM = BOM;
    }

    private static class LineSeparators {
        private String mySeparator;

        private LineSeparators() {
        }

        public String correctText(String text) {
            DiffString.LineTokenizer lineTokenizer = new DiffString.LineTokenizer(DiffString.create((String)text));
            DiffString[] lines = lineTokenizer.execute();
            this.mySeparator = lineTokenizer.getLineSeparator();
            LOG.assertTrue(this.mySeparator == null || !this.mySeparator.isEmpty());
            if (this.mySeparator == null) {
                this.mySeparator = SystemProperties.getLineSeparator();
            }
            return DiffString.concatenate((DiffString[])lines).toString();
        }

        public String restoreText(String text) {
            if (this.mySeparator == null) {
                throw new NullPointerException();
            }
            return text.replaceAll("\n", this.mySeparator);
        }
    }
}

