/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch;

import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchHunk;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TextFilePatch
extends FilePatch {
    private Charset myCharset;
    private final List<PatchHunk> myHunks;

    public void addHunk(PatchHunk hunk) {
        this.myHunks.add(hunk);
    }

    public List<PatchHunk> getHunks() {
        return Collections.unmodifiableList(this.myHunks);
    }

    public TextFilePatch(Charset charset) {
        this.myCharset = charset;
        this.myHunks = new ArrayList<PatchHunk>();
    }

    private TextFilePatch(TextFilePatch patch) {
        this.myCharset = patch.myCharset;
        this.setBeforeVersionId(patch.getBeforeVersionId());
        this.setAfterVersionId(patch.getAfterVersionId());
        this.setBeforeName(patch.getBeforeName());
        this.setAfterName(patch.getAfterName());
        this.myHunks = patch.myHunks;
    }

    public TextFilePatch pathsOnlyCopy() {
        return new TextFilePatch(this);
    }

    @Override
    public boolean isNewFile() {
        return this.myHunks.size() == 1 && this.myHunks.get(0).isNewContent();
    }

    public String getNewFileText() {
        return this.myHunks.get(0).getText();
    }

    @Override
    public boolean isDeletedFile() {
        return this.myHunks.size() == 1 && this.myHunks.get(0).isDeletedContent();
    }

    public Charset getCharset() {
        return this.myCharset;
    }

    @Deprecated
    public void setCharset(Charset charset) {
        this.myCharset = charset;
    }
}

