/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.editor.IndentStrategy;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;

public class LanguageIndentStrategy
extends LanguageExtension<IndentStrategy> {
    public static final String EP_NAME = "com.intellij.lang.indentStrategy";
    public static final LanguageIndentStrategy INSTANCE = new LanguageIndentStrategy();
    private static final DefaultIndentStrategy DEFAULT_INDENT_STRATEGY = new DefaultIndentStrategy();

    public LanguageIndentStrategy() {
        super(EP_NAME, DEFAULT_INDENT_STRATEGY);
    }

    public static IndentStrategy getIndentStrategy(PsiFile file) {
        Language language;
        IndentStrategy strategy;
        if (file != null && (strategy = (IndentStrategy)INSTANCE.forLanguage(language = file.getLanguage())) != null) {
            return strategy;
        }
        return DEFAULT_INDENT_STRATEGY;
    }

    public static boolean isDefault(IndentStrategy indentStrategy) {
        return indentStrategy == DEFAULT_INDENT_STRATEGY;
    }

    private static class DefaultIndentStrategy
    implements IndentStrategy {
        private DefaultIndentStrategy() {
        }

        @Override
        public boolean canIndent(PsiElement element) {
            return true;
        }
    }
}

