/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actionSystem;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.DialogAwareDataContext;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionHandlerBean;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import java.awt.event.KeyEvent;

public abstract class EditorAction
extends AnAction
implements DumbAware {
    private EditorActionHandler myHandler;
    private boolean myHandlersLoaded;

    public final EditorActionHandler getHandler() {
        this.ensureHandlersLoaded();
        return this.myHandler;
    }

    protected EditorAction(EditorActionHandler defaultHandler) {
        this.myHandler = defaultHandler;
        this.setEnabledInModalContext(true);
    }

    public final EditorActionHandler setupHandler(EditorActionHandler newHandler) {
        this.ensureHandlersLoaded();
        EditorActionHandler tmp = this.myHandler;
        this.myHandler = newHandler;
        this.myHandler.setWorksInInjected(this.isInInjectedContext());
        return tmp;
    }

    private void ensureHandlersLoaded() {
        if (!this.myHandlersLoaded) {
            this.myHandlersLoaded = true;
            String id = ActionManager.getInstance().getId(this);
            EditorActionHandlerBean[] extensions = (EditorActionHandlerBean[])Extensions.getExtensions(EditorActionHandlerBean.EP_NAME);
            for (int i = extensions.length - 1; i >= 0; --i) {
                EditorActionHandlerBean handlerBean = extensions[i];
                if (!handlerBean.action.equals(id)) continue;
                this.myHandler = handlerBean.getHandler(this.myHandler);
                this.myHandler.setWorksInInjected(this.isInInjectedContext());
            }
        }
    }

    @Override
    public void setInjectedContext(boolean worksInInjected) {
        super.setInjectedContext(worksInInjected);
        this.myHandler.setWorksInInjected(this.isInInjectedContext());
    }

    @Override
    public final void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Editor editor = this.getEditor(dataContext);
        this.actionPerformed(editor, dataContext);
    }

    protected Editor getEditor(DataContext dataContext) {
        return CommonDataKeys.EDITOR.getData(dataContext);
    }

    public final void actionPerformed(final Editor editor, final DataContext dataContext) {
        if (editor == null) {
            return;
        }
        final EditorActionHandler handler = this.getHandler();
        Runnable command = new Runnable(){

            @Override
            public void run() {
                handler.execute(editor, null, EditorAction.getProjectAwareDataContext(editor, dataContext));
            }
        };
        if (!handler.executeInCommand(editor, dataContext)) {
            command.run();
            return;
        }
        String commandName = this.getTemplatePresentation().getText();
        if (commandName == null) {
            commandName = "";
        }
        CommandProcessor.getInstance().executeCommand(editor.getProject(), command, commandName, handler.getCommandGroupId(editor), UndoConfirmationPolicy.DEFAULT, editor.getDocument());
    }

    public void update(Editor editor, Presentation presentation, DataContext dataContext) {
        presentation.setEnabled(this.getHandler().isEnabled(editor, null, dataContext));
    }

    public void updateForKeyboardAccess(Editor editor, Presentation presentation, DataContext dataContext) {
        this.update(editor, presentation, dataContext);
    }

    @Override
    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        DataContext dataContext = e.getDataContext();
        Editor editor = this.getEditor(dataContext);
        if (editor == null) {
            presentation.setEnabled(false);
        } else if (e.getInputEvent() instanceof KeyEvent) {
            this.updateForKeyboardAccess(editor, presentation, dataContext);
        } else {
            this.update(editor, presentation, dataContext);
        }
    }

    private static DataContext getProjectAwareDataContext(final Editor editor, final DataContext original) {
        if (CommonDataKeys.PROJECT.getData(original) == editor.getProject()) {
            return new DialogAwareDataContext(original);
        }
        return new DataContext(){

            @Override
            public Object getData(String dataId) {
                Project project;
                if (CommonDataKeys.PROJECT.is(dataId) && (project = editor.getProject()) != null) {
                    return project;
                }
                return original.getData(dataId);
            }
        };
    }
}

