/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors;

import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import javax.swing.JComponent;

public class EditorColorsUtil {
    private EditorColorsUtil() {
    }

    public static EditorColorsScheme getGlobalOrDefaultColorScheme() {
        return EditorColorsUtil.getColorSchemeForBackground(null);
    }

    public static EditorColorsScheme getColorSchemeForComponent(JComponent component) {
        return EditorColorsUtil.getColorSchemeForBackground(component != null ? component.getBackground() : null);
    }

    public static EditorColorsScheme getColorSchemeForBackground(Color background) {
        EditorColorsScheme scheme;
        EditorColorsScheme globalScheme;
        boolean dark2;
        boolean dark1 = background == null ? UIUtil.isUnderDarcula() : ColorUtil.isDark((Color)background);
        if (dark1 != (dark2 = ColorUtil.isDark((Color)(globalScheme = EditorColorsManager.getInstance().getGlobalScheme()).getDefaultBackground())) && (scheme = EditorColorsManager.getInstance().getScheme("Default")) != null) {
            return scheme;
        }
        return globalScheme;
    }
}

