/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.VolatileNullableLazyValue;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.concurrent.ConcurrentMap;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public final class TextAttributesKey
implements Comparable<TextAttributesKey> {
    private static final TextAttributes NULL_ATTRIBUTES = new TextAttributes();
    private static final ConcurrentMap<String, TextAttributesKey> ourRegistry = ContainerUtil.newConcurrentMap();
    private static final NullableLazyValue<TextAttributeKeyDefaultsProvider> ourDefaultsProvider = new VolatileNullableLazyValue<TextAttributeKeyDefaultsProvider>(){

        protected TextAttributeKeyDefaultsProvider compute() {
            return ServiceManager.getService(TextAttributeKeyDefaultsProvider.class);
        }
    };
    private final String myExternalName;
    private TextAttributes myDefaultAttributes = NULL_ATTRIBUTES;
    private TextAttributesKey myFallbackAttributeKey;

    private TextAttributesKey(String externalName) {
        this.myExternalName = externalName;
    }

    public TextAttributesKey(Element element) throws InvalidDataException {
        this(JDOMExternalizerUtil.readField((Element)element, (String)"myExternalName"));
        Element myDefaultAttributesElement = JDOMExternalizerUtil.getOption((Element)element, (String)"myDefaultAttributes");
        if (myDefaultAttributesElement != null) {
            this.myDefaultAttributes = new TextAttributes(myDefaultAttributesElement);
        }
    }

    public static TextAttributesKey find(@NonNls String externalName) {
        return (TextAttributesKey)ConcurrencyUtil.cacheOrGet(ourRegistry, (Object)externalName, (Object)new TextAttributesKey(externalName));
    }

    public String toString() {
        return this.myExternalName;
    }

    public String getExternalName() {
        return this.myExternalName;
    }

    @Override
    public int compareTo(TextAttributesKey key) {
        return this.myExternalName.compareTo(key.myExternalName);
    }

    public static TextAttributesKey createTextAttributesKey(@NonNls String externalName) {
        return TextAttributesKey.find(externalName);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        JDOMExternalizerUtil.writeField((Element)element, (String)"myExternalName", (String)this.myExternalName);
        if (this.myDefaultAttributes != NULL_ATTRIBUTES) {
            Element option = JDOMExternalizerUtil.writeOption((Element)element, (String)"myDefaultAttributes");
            this.myDefaultAttributes.writeExternal(option);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextAttributesKey that = (TextAttributesKey)o;
        return this.myExternalName.equals(that.myExternalName);
    }

    public int hashCode() {
        return this.myExternalName.hashCode();
    }

    public TextAttributes getDefaultAttributes() {
        if (this.myDefaultAttributes == NULL_ATTRIBUTES) {
            this.myDefaultAttributes = null;
            TextAttributeKeyDefaultsProvider provider = (TextAttributeKeyDefaultsProvider)ourDefaultsProvider.getValue();
            if (provider != null) {
                this.myDefaultAttributes = provider.getDefaultAttributes(this);
            }
        } else if (this.myDefaultAttributes == null) {
            this.myDefaultAttributes = NULL_ATTRIBUTES;
        }
        return this.myDefaultAttributes;
    }

    @Deprecated
    public static TextAttributesKey createTextAttributesKey(@NonNls String externalName, TextAttributes defaultAttributes) {
        TextAttributesKey key = TextAttributesKey.find(externalName);
        if (key.myDefaultAttributes == null || key.myDefaultAttributes == NULL_ATTRIBUTES) {
            key.myDefaultAttributes = defaultAttributes;
        }
        return key;
    }

    public static TextAttributesKey createTextAttributesKey(@NonNls String externalName, TextAttributesKey fallbackAttributeKey) {
        TextAttributesKey key = TextAttributesKey.find(externalName);
        key.setFallbackAttributeKey(fallbackAttributeKey);
        return key;
    }

    public TextAttributesKey getFallbackAttributeKey() {
        return this.myFallbackAttributeKey;
    }

    public void setFallbackAttributeKey(TextAttributesKey fallbackAttributeKey) {
        this.myFallbackAttributeKey = fallbackAttributeKey;
    }

    public static interface TextAttributeKeyDefaultsProvider {
        public TextAttributes getDefaultAttributes(TextAttributesKey var1);
    }
}

