/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.markup;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.AttributesFlyweight;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.util.InvalidDataException;
import java.awt.Color;
import org.intellij.lang.annotations.JdkConstants;
import org.jdom.Element;

public class TextAttributes
implements Cloneable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.markup.TextAttributes");
    public static final TextAttributes ERASE_MARKER = new TextAttributes();
    private boolean myEnforcedDefaults;
    private AttributesFlyweight myAttrs;

    public static TextAttributes merge(TextAttributes under, TextAttributes above) {
        if (under == null) {
            return above;
        }
        if (above == null) {
            return under;
        }
        TextAttributes attrs = under.clone();
        if (above.getBackgroundColor() != null) {
            attrs.setBackgroundColor(above.getBackgroundColor());
        }
        if (above.getForegroundColor() != null) {
            attrs.setForegroundColor(above.getForegroundColor());
        }
        attrs.setFontType(above.getFontType() | under.getFontType());
        if (above.getEffectColor() != null) {
            attrs.setEffectColor(above.getEffectColor());
            attrs.setEffectType(above.getEffectType());
        }
        return attrs;
    }

    public TextAttributes() {
        this(null, null, null, EffectType.BOXED, 0);
    }

    private TextAttributes(AttributesFlyweight attributesFlyweight, boolean enforced) {
        this.myAttrs = attributesFlyweight;
        this.myEnforcedDefaults = enforced;
    }

    public TextAttributes(Element element) {
        this.readExternal(element);
    }

    public TextAttributes(Color foregroundColor, Color backgroundColor, Color effectColor, EffectType effectType, @JdkConstants.FontStyle int fontType) {
        this.setAttributes(foregroundColor, backgroundColor, effectColor, null, effectType, fontType);
    }

    public void setAttributes(Color foregroundColor, Color backgroundColor, Color effectColor, Color errorStripeColor, EffectType effectType, @JdkConstants.FontStyle int fontType) {
        this.myAttrs = AttributesFlyweight.create(foregroundColor, backgroundColor, fontType, effectColor, effectType, errorStripeColor);
    }

    public boolean isEmpty() {
        return this.getForegroundColor() == null && this.getBackgroundColor() == null && this.getEffectColor() == null && this.getFontType() == 0;
    }

    public boolean isFallbackEnabled() {
        return this.isEmpty() && !this.myEnforcedDefaults;
    }

    public void reset() {
        this.setForegroundColor(null);
        this.setBackgroundColor(null);
        this.setEffectColor(null);
        this.setFontType(0);
    }

    public AttributesFlyweight getFlyweight() {
        return this.myAttrs;
    }

    public static TextAttributes fromFlyweight(AttributesFlyweight flyweight) {
        TextAttributes f = new TextAttributes();
        f.myAttrs = flyweight;
        return f;
    }

    public Color getForegroundColor() {
        return this.myAttrs.getForeground();
    }

    public void setForegroundColor(Color color) {
        this.myAttrs = this.myAttrs.withForeground(color);
    }

    public Color getBackgroundColor() {
        return this.myAttrs.getBackground();
    }

    public void setBackgroundColor(Color color) {
        this.myAttrs = this.myAttrs.withBackground(color);
    }

    public Color getEffectColor() {
        return this.myAttrs.getEffectColor();
    }

    public void setEffectColor(Color color) {
        this.myAttrs = this.myAttrs.withEffectColor(color);
    }

    public Color getErrorStripeColor() {
        return this.myAttrs.getErrorStripeColor();
    }

    public void setErrorStripeColor(Color color) {
        this.myAttrs = this.myAttrs.withErrorStripeColor(color);
    }

    public EffectType getEffectType() {
        return this.myAttrs.getEffectType();
    }

    public void setEffectType(EffectType effectType) {
        this.myAttrs = this.myAttrs.withEffectType(effectType);
    }

    @JdkConstants.FontStyle
    public int getFontType() {
        return this.myAttrs.getFontType();
    }

    public void setFontType(@JdkConstants.FontStyle int type) {
        if (type < 0 || type > 3) {
            LOG.error("Wrong font type: " + type);
            type = 0;
        }
        this.myAttrs = this.myAttrs.withFontType(type);
    }

    public TextAttributes clone() {
        return new TextAttributes(this.myAttrs, this.myEnforcedDefaults);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TextAttributes)) {
            return false;
        }
        return this.myAttrs == ((TextAttributes)obj).myAttrs;
    }

    public int hashCode() {
        return this.myAttrs.hashCode();
    }

    public void readExternal(Element element) {
        try {
            this.myAttrs = AttributesFlyweight.create(element);
        }
        catch (InvalidDataException e) {
            throw new RuntimeException(e);
        }
        if (this.isEmpty()) {
            this.myEnforcedDefaults = true;
        }
    }

    public void writeExternal(Element element) {
        this.myAttrs.writeExternal(element);
    }

    public String toString() {
        return "[" + this.getForegroundColor() + "," + this.getBackgroundColor() + "," + this.getFontType() + "," + (Object)((Object)this.getEffectType()) + "," + this.getEffectColor() + "," + this.getErrorStripeColor() + "]";
    }
}

