/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model;

import com.intellij.openapi.externalSystem.model.DefaultExternalFilter;
import com.intellij.openapi.externalSystem.model.ExternalFilter;
import com.intellij.openapi.externalSystem.model.ExternalSourceDirectorySet;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DefaultExternalSourceDirectorySet
implements ExternalSourceDirectorySet {
    private static final long serialVersionUID = 1L;
    private String myName;
    private Set<File> mySrcDirs = new HashSet<File>();
    private File myOutputDir;
    private Set<String> myExcludes = new HashSet<String>();
    private Set<String> myIncludes = new HashSet<String>();
    private List<ExternalFilter> myFilters = new ArrayList<ExternalFilter>();
    private boolean myInheritedCompilerOutput;

    public DefaultExternalSourceDirectorySet() {
    }

    public DefaultExternalSourceDirectorySet(ExternalSourceDirectorySet sourceDirectorySet) {
        this();
        this.myName = sourceDirectorySet.getName();
        this.mySrcDirs = new HashSet<File>(sourceDirectorySet.getSrcDirs());
        this.myOutputDir = sourceDirectorySet.getOutputDir();
        this.myExcludes = new HashSet<String>(sourceDirectorySet.getExcludes());
        this.myIncludes = new HashSet<String>(sourceDirectorySet.getIncludes());
        for (ExternalFilter filter : sourceDirectorySet.getFilters()) {
            this.myFilters.add(new DefaultExternalFilter(filter));
        }
    }

    @Override
    public String getName() {
        return this.myName;
    }

    public void setName(String name) {
        this.myName = name;
    }

    @Override
    public Set<File> getSrcDirs() {
        return this.mySrcDirs;
    }

    public void setSrcDirs(Set<File> srcDirs) {
        this.mySrcDirs = srcDirs;
    }

    @Override
    public File getOutputDir() {
        return this.myOutputDir;
    }

    @Override
    public boolean isCompilerOutputPathInherited() {
        return this.myInheritedCompilerOutput;
    }

    public void setInheritedCompilerOutput(boolean inheritedCompilerOutput) {
        this.myInheritedCompilerOutput = inheritedCompilerOutput;
    }

    @Override
    public Set<String> getIncludes() {
        return this.myIncludes;
    }

    public void setIncludes(Set<String> includes) {
        this.myIncludes = includes;
    }

    @Override
    public Set<String> getExcludes() {
        return this.myExcludes;
    }

    public void setExcludes(Set<String> excludes) {
        this.myExcludes = excludes;
    }

    @Override
    public List<ExternalFilter> getFilters() {
        return this.myFilters;
    }

    public void setFilters(List<ExternalFilter> filters) {
        this.myFilters = filters;
    }

    public void setOutputDir(File outputDir) {
        this.myOutputDir = outputDir;
    }
}

