/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;

public class ExternalSystemException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final String myOriginalReason;
    private final String[] myQuickFixes;

    public ExternalSystemException() {
        this(null, (Throwable)null, new String[0]);
    }

    public ExternalSystemException(String message) {
        this(message, (Throwable)null, new String[0]);
    }

    public ExternalSystemException(Throwable cause) {
        this("", cause, new String[0]);
    }

    public ExternalSystemException(String message, String ... quickFixes) {
        this(message, (Throwable)null, quickFixes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExternalSystemException(String message, Throwable cause, String ... quickFixes) {
        super(ExternalSystemException.extractMessage(message, cause));
        this.myQuickFixes = ExternalSystemException.mergeArrays(cause instanceof ExternalSystemException ? ((ExternalSystemException)cause).getQuickFixes() : new String[]{}, quickFixes);
        if (cause == null) {
            this.myOriginalReason = "";
            return;
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        try {
            cause.printStackTrace(printWriter);
        }
        finally {
            printWriter.close();
        }
        this.myOriginalReason = stringWriter.toString();
    }

    public String getOriginalReason() {
        return this.myOriginalReason;
    }

    public String[] getQuickFixes() {
        return this.myQuickFixes;
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        super.printStackTrace(s);
        s.println(this.myOriginalReason);
    }

    @Override
    public void printStackTrace(PrintStream s) {
        super.printStackTrace(s);
        s.println(this.myOriginalReason);
    }

    private static String extractMessage(String message, Throwable cause) {
        StringBuilder buffer = new StringBuilder();
        if (message != null) {
            buffer.append(message);
        }
        boolean first = true;
        for (Throwable t = cause; t != null; t = t.getCause()) {
            String m = t.getLocalizedMessage();
            if (m == null) continue;
            if (first) {
                first = false;
            } else if (buffer.length() > 0) {
                buffer.append("\n");
            }
            buffer.append(m);
        }
        return buffer.toString();
    }

    private static String[] mergeArrays(String[] a1, String[] a2) {
        if (a1.length == 0) {
            return a2;
        }
        if (a2.length == 0) {
            return a1;
        }
        String[] result = new String[a1.length + a2.length];
        System.arraycopy(a1, 0, result, 0, a1.length);
        System.arraycopy(a2, 0, result, a1.length, a2.length);
        return result;
    }
}

