/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.execution;

import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.util.text.StringUtil;

public class ExternalTaskExecutionInfo {
    private ExternalSystemTaskExecutionSettings mySettings;
    private String myExecutorId;

    public ExternalTaskExecutionInfo() {
        this(new ExternalSystemTaskExecutionSettings(), "___DUMMY___");
    }

    public ExternalTaskExecutionInfo(ExternalSystemTaskExecutionSettings settings, String executorId) {
        this.mySettings = settings;
        this.myExecutorId = executorId;
    }

    public ExternalSystemTaskExecutionSettings getSettings() {
        return this.mySettings;
    }

    public void setSettings(ExternalSystemTaskExecutionSettings settings) {
        this.mySettings = settings;
    }

    public String getExecutorId() {
        return this.myExecutorId;
    }

    public void setExecutorId(String executorId) {
        this.myExecutorId = executorId;
    }

    public String getDescription() {
        return StringUtil.join(this.mySettings.getTaskDescriptions(), (String)"\n");
    }

    public int hashCode() {
        int result = this.mySettings.hashCode();
        result = 31 * result + this.myExecutorId.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalTaskExecutionInfo task = (ExternalTaskExecutionInfo)o;
        if (!this.myExecutorId.equals(task.myExecutorId)) {
            return false;
        }
        return this.mySettings.equals(task.mySettings);
    }

    public String toString() {
        return StringUtil.join(this.mySettings.getTaskNames(), (String)" ");
    }
}

