/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.project;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.AbstractExternalEntityData;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;

public class ContentRootData
extends AbstractExternalEntityData {
    private static final long serialVersionUID = 1L;
    private final Map<ExternalSystemSourceType, Collection<SourceRoot>> myData = ContainerUtilRt.newHashMap();
    private final String myRootPath;

    public ContentRootData(ProjectSystemId owner, String rootPath) {
        super(owner);
        this.myRootPath = ExternalSystemApiUtil.toCanonicalPath(rootPath);
    }

    public Collection<SourceRoot> getPaths(ExternalSystemSourceType type) {
        Collection<SourceRoot> result = this.myData.get(type);
        return result == null ? Collections.emptyList() : result;
    }

    public void storePath(ExternalSystemSourceType type, String path) throws IllegalArgumentException {
        this.storePath(type, path, null);
    }

    public void storePath(ExternalSystemSourceType type, String path, String packagePrefix) throws IllegalArgumentException {
        if (FileUtil.isAncestor((File)new File(this.getRootPath()), (File)new File(path), (boolean)false)) {
            Collection<SourceRoot> paths = this.myData.get(type);
            if (paths == null) {
                paths = new TreeSet<SourceRoot>(SourceRootComparator.INSTANCE);
                this.myData.put(type, paths);
            }
            paths.add(new SourceRoot(ExternalSystemApiUtil.toCanonicalPath(path), StringUtil.nullize((String)packagePrefix, (boolean)true)));
            return;
        }
        if (!ExternalSystemSourceType.EXCLUDED.equals(type)) {
            throw new IllegalArgumentException(String.format("Can't register given path of type '%s' because it's out of content root.%nContent root: '%s'%nGiven path: '%s'", type, this.getRootPath(), new File(path).getAbsolutePath()));
        }
    }

    public String getRootPath() {
        return this.myRootPath;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("content root:");
        for (Map.Entry<ExternalSystemSourceType, Collection<SourceRoot>> entry : this.myData.entrySet()) {
            buffer.append(entry.getKey().toString().toLowerCase(Locale.ENGLISH)).append("=").append(entry.getValue()).append("|");
        }
        if (!this.myData.isEmpty()) {
            buffer.setLength(buffer.length() - 1);
        }
        return buffer.toString();
    }

    private static final class SourceRootComparator
    implements Comparator<SourceRoot>,
    Serializable {
        private static final SourceRootComparator INSTANCE = new SourceRootComparator();

        private SourceRootComparator() {
        }

        @Override
        public int compare(SourceRoot o1, SourceRoot o2) {
            return StringUtil.naturalCompare((String)o1.myPath, (String)o2.myPath);
        }
    }

    public static class SourceRoot
    implements Serializable {
        private final String myPath;
        private final String myPackagePrefix;

        public SourceRoot(String path, String prefix) {
            this.myPath = path;
            this.myPackagePrefix = prefix;
        }

        public String getPath() {
            return this.myPath;
        }

        public String getPackagePrefix() {
            return this.myPackagePrefix;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SourceRoot)) {
                return false;
            }
            SourceRoot root = (SourceRoot)o;
            if (this.myPackagePrefix != null ? !this.myPackagePrefix.equals(root.myPackagePrefix) : root.myPackagePrefix != null) {
                return false;
            }
            return this.myPath.equals(root.myPath);
        }

        public int hashCode() {
            int result = this.myPath.hashCode();
            result = 31 * result + (this.myPackagePrefix != null ? this.myPackagePrefix.hashCode() : 0);
            return result;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder("source_root(");
            buffer.append(this.myPath);
            if (this.myPackagePrefix != null) {
                buffer.append(", ").append(this.myPackagePrefix);
            }
            buffer.append(")");
            return buffer.toString();
        }
    }
}

