/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.project;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.AbstractNamedData;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.Named;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.util.containers.HashMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class LibraryData
extends AbstractNamedData
implements Named {
    private static final long serialVersionUID = 1L;
    private final Map<LibraryPathType, Set<String>> myPaths = new HashMap();
    private final boolean myUnresolved;

    public LibraryData(ProjectSystemId owner, String name) {
        this(owner, name, false);
    }

    public LibraryData(ProjectSystemId owner, String name, boolean unresolved) {
        super(owner, name, String.format("%s: %s", owner.getReadableName(), name));
        this.myUnresolved = unresolved;
    }

    public boolean isUnresolved() {
        return this.myUnresolved;
    }

    public Set<String> getPaths(LibraryPathType type) {
        Set<String> result = this.myPaths.get((Object)type);
        return result == null ? Collections.emptySet() : result;
    }

    public void addPath(LibraryPathType type, String path) {
        Set<String> paths = this.myPaths.get((Object)type);
        if (paths == null) {
            paths = new HashSet<String>();
            this.myPaths.put(type, paths);
        }
        paths.add(ExternalSystemApiUtil.toCanonicalPath(path));
    }

    public void forgetAllPaths() {
        this.myPaths.clear();
    }

    @Override
    public int hashCode() {
        int result = ((Object)this.myPaths).hashCode();
        result = 31 * result + super.hashCode();
        result = 31 * result + (this.myUnresolved ? 0 : 1);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        LibraryData that = (LibraryData)o;
        return super.equals(that) && this.myUnresolved == that.myUnresolved && ((Object)this.myPaths).equals(that.myPaths);
    }

    public String toString() {
        return String.format("library %s%s", this.getExternalName(), this.myUnresolved ? "(unresolved)" : "");
    }
}

