/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.project;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.AbstractNamedData;
import com.intellij.openapi.externalSystem.model.project.ExternalConfigPathAware;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.Identifiable;
import com.intellij.openapi.externalSystem.model.project.Named;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ModuleData
extends AbstractNamedData
implements Named,
ExternalConfigPathAware,
Identifiable {
    private static final long serialVersionUID = 1L;
    private final Map<ExternalSystemSourceType, String> myCompileOutputPaths = ContainerUtil.newHashMap();
    private final String myId;
    private final String myModuleTypeId;
    private final String myExternalConfigPath;
    private String myModuleFilePath;
    private String group;
    private String version;
    private List<File> myArtifacts;
    private boolean myInheritProjectCompileOutputPath = true;

    @Deprecated
    public ModuleData(ProjectSystemId owner, String typeId, String name, String moduleFileDirectoryPath, String externalConfigPath) {
        this("", owner, typeId, name, moduleFileDirectoryPath, externalConfigPath);
    }

    public ModuleData(String id, ProjectSystemId owner, String typeId, String name, String moduleFileDirectoryPath, String externalConfigPath) {
        super(owner, name, name.replaceAll("(/|\\\\)", "_"));
        this.myId = id;
        this.myModuleTypeId = typeId;
        this.myExternalConfigPath = externalConfigPath;
        this.myArtifacts = Collections.emptyList();
        this.setModuleFileDirectoryPath(moduleFileDirectoryPath);
    }

    @Override
    public String getId() {
        return this.myId;
    }

    public String getModuleTypeId() {
        return this.myModuleTypeId;
    }

    @Override
    public String getLinkedExternalProjectPath() {
        return this.myExternalConfigPath;
    }

    public String getModuleFilePath() {
        return this.myModuleFilePath;
    }

    public void setModuleFileDirectoryPath(String path) {
        this.myModuleFilePath = ExternalSystemApiUtil.toCanonicalPath(path + "/" + this.getInternalName() + ".iml");
    }

    public boolean isInheritProjectCompileOutputPath() {
        return this.myInheritProjectCompileOutputPath;
    }

    public void setInheritProjectCompileOutputPath(boolean inheritProjectCompileOutputPath) {
        this.myInheritProjectCompileOutputPath = inheritProjectCompileOutputPath;
    }

    public String getCompileOutputPath(ExternalSystemSourceType type) {
        return this.myCompileOutputPaths.get(type);
    }

    public void setCompileOutputPath(ExternalSystemSourceType type, String path) {
        if (path == null) {
            this.myCompileOutputPaths.remove(type);
            return;
        }
        this.myCompileOutputPaths.put(type, ExternalSystemApiUtil.toCanonicalPath(path));
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public List<File> getArtifacts() {
        return this.myArtifacts;
    }

    public void setArtifacts(List<File> artifacts) {
        this.myArtifacts = artifacts;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ModuleData)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ModuleData that = (ModuleData)o;
        if (this.group != null ? !this.group.equals(that.group) : that.group != null) {
            return false;
        }
        if (!this.myModuleTypeId.equals(that.myModuleTypeId)) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(that.version) : that.version != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myModuleTypeId.hashCode();
        result = 31 * result + (this.group != null ? this.group.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        return result;
    }

    public String toString() {
        return String.format("module '%s:%s:%s'", this.group == null ? "" : this.group, this.getExternalName(), this.version == null ? "" : this.version);
    }
}

