/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.util;

public class ArtifactInfo {
    private final String myName;
    private final String myGroup;
    private final String myVersion;

    public ArtifactInfo(String name, String group, String version) {
        assert (name != null || group != null || version != null);
        this.myName = name;
        this.myGroup = group;
        this.myVersion = version;
    }

    public String getName() {
        return this.myName;
    }

    public String getVersion() {
        return this.myVersion;
    }

    public int hashCode() {
        int result = this.myName != null ? this.myName.hashCode() : 0;
        result = 31 * result + (this.myGroup != null ? this.myGroup.hashCode() : 0);
        result = 31 * result + (this.myVersion != null ? this.myVersion.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArtifactInfo info = (ArtifactInfo)o;
        if (this.myGroup != null ? !this.myGroup.equals(info.myGroup) : info.myGroup != null) {
            return false;
        }
        if (this.myName != null ? !this.myName.equals(info.myName) : info.myName != null) {
            return false;
        }
        return !(this.myVersion != null ? !this.myVersion.equals(info.myVersion) : info.myVersion != null);
    }

    public String toString() {
        return String.format("%s:%s:%s", this.myName == null ? "<no-name>" : this.myName, this.myGroup == null ? "<no-group>" : this.myGroup, this.myVersion == null ? "<no-version>" : this.myVersion);
    }
}

