/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.util;

import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemAutoImportAware;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.service.ParametersEnhancer;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListener;
import com.intellij.openapi.externalSystem.util.ArtifactInfo;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.BooleanFunction;
import com.intellij.util.Consumer;
import com.intellij.util.NullableFunction;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.Stack;
import com.intellij.util.containers.TransferToEDTQueue;
import com.intellij.util.lang.UrlClassLoader;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExternalSystemApiUtil {
    private static final Logger LOG = Logger.getInstance((String)("#" + ExternalSystemApiUtil.class.getName()));
    private static final String LAST_USED_PROJECT_PATH_PREFIX = "LAST_EXTERNAL_PROJECT_PATH_";
    public static final String PATH_SEPARATOR = "/";
    private static final Pattern ARTIFACT_PATTERN = Pattern.compile("(?:.*/)?(.+?)(?:-([\\d+](?:\\.[\\d]+)*))?(?:\\.[^\\.]+?)?");
    public static final Comparator<Object> ORDER_AWARE_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            int order2;
            int order1 = this.getOrder(o1);
            return order1 < (order2 = this.getOrder(o2)) ? -1 : (order1 == order2 ? 0 : 1);
        }

        private int getOrder(Object o) {
            ArrayDeque toCheck = new ArrayDeque();
            toCheck.add(o.getClass());
            while (!toCheck.isEmpty()) {
                Class clazz = (Class)toCheck.poll();
                Order annotation = clazz.getAnnotation(Order.class);
                if (annotation != null) {
                    return annotation.value();
                }
                Class c = clazz.getSuperclass();
                if (c != null) {
                    toCheck.add(c);
                }
                Class<?>[] interfaces = clazz.getInterfaces();
                Collections.addAll(toCheck, interfaces);
            }
            return 1000;
        }
    };
    private static final NullableFunction<DataNode<?>, Key<?>> GROUPER = new NullableFunction<DataNode<?>, Key<?>>(){

        public Key<?> fun(DataNode<?> node) {
            return node.getKey();
        }
    };
    private static final Comparator<Object> COMPARABLE_GLUE = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            return ((Comparable)o1).compareTo(o2);
        }
    };
    private static final TransferToEDTQueue<Runnable> TRANSFER_TO_EDT_QUEUE = new TransferToEDTQueue("External System queue", (Processor)new Processor<Runnable>(){

        public boolean process(Runnable runnable) {
            runnable.run();
            return true;
        }
    }, Conditions.alwaysFalse(), 300);

    private ExternalSystemApiUtil() {
    }

    public static String extractNameFromPath(String path) {
        String strippedPath = ExternalSystemApiUtil.stripPath(path);
        int i = strippedPath.lastIndexOf(PATH_SEPARATOR);
        String result = i < 0 || i >= strippedPath.length() - 1 ? strippedPath : strippedPath.substring(i + 1);
        return result;
    }

    private static String stripPath(String path) {
        String[] endingsToStrip = new String[]{PATH_SEPARATOR, "!", ".jar"};
        StringBuilder buffer = new StringBuilder(path);
        for (String ending : endingsToStrip) {
            if (buffer.lastIndexOf(ending) != buffer.length() - ending.length()) continue;
            buffer.setLength(buffer.length() - ending.length());
        }
        return buffer.toString();
    }

    public static String getLibraryName(Library library) {
        String result = library.getName();
        if (result != null) {
            return result;
        }
        for (OrderRootType type : OrderRootType.getAllTypes()) {
            for (String url : library.getUrls(type)) {
                String candidate = ExternalSystemApiUtil.extractNameFromPath(url);
                if (StringUtil.isEmpty((String)candidate)) continue;
                return candidate;
            }
        }
        assert (false);
        return "unknown-lib";
    }

    public static boolean isRelated(Library library, LibraryData libraryData) {
        return ExternalSystemApiUtil.getLibraryName(library).equals(libraryData.getInternalName());
    }

    public static boolean isExternalSystemLibrary(Library library, ProjectSystemId externalSystemId) {
        return library.getName() != null && StringUtil.startsWith((CharSequence)library.getName(), (CharSequence)(externalSystemId.getReadableName() + ": "));
    }

    public static ArtifactInfo parseArtifactInfo(String fileName) {
        Matcher matcher = ARTIFACT_PATTERN.matcher(fileName);
        if (!matcher.matches()) {
            return null;
        }
        return new ArtifactInfo(matcher.group(1), null, matcher.group(2));
    }

    public static void orderAwareSort(List<?> data) {
        Collections.sort(data, ORDER_AWARE_COMPARATOR);
    }

    public static String toCanonicalPath(String path) {
        String p = ExternalSystemApiUtil.normalizePath(new File(path).getAbsolutePath());
        assert (p != null);
        return PathUtil.getCanonicalPath(p);
    }

    public static String getLocalFileSystemPath(VirtualFile file) {
        VirtualFile jar;
        if (file.getFileType() == FileTypes.ARCHIVE && (jar = JarFileSystem.getInstance().getVirtualFileForJar(file)) != null) {
            return jar.getPath();
        }
        return ExternalSystemApiUtil.toCanonicalPath(file.getPath());
    }

    public static ExternalSystemManager<?, ?, ?, ?, ?> getManager(ProjectSystemId externalSystemId) {
        for (ExternalSystemManager manager : (ExternalSystemManager[])ExternalSystemManager.EP_NAME.getExtensions()) {
            if (!externalSystemId.equals(manager.getSystemId())) continue;
            return manager;
        }
        return null;
    }

    public static Collection<ExternalSystemManager<?, ?, ?, ?, ?>> getAllManagers() {
        ArrayList result = ContainerUtilRt.newArrayList();
        for (ExternalSystemManager manager : (ExternalSystemManager[])ExternalSystemManager.EP_NAME.getExtensions()) {
            result.add(manager);
        }
        return result;
    }

    public static Map<Key<?>, List<DataNode<?>>> group(Collection<DataNode<?>> nodes) {
        return ExternalSystemApiUtil.groupBy(nodes, GROUPER);
    }

    public static <K, V> Map<DataNode<K>, List<DataNode<V>>> groupBy(Collection<DataNode<V>> nodes, final Key<K> key) {
        return ExternalSystemApiUtil.groupBy(nodes, new NullableFunction<DataNode<V>, DataNode<K>>(){

            public DataNode<K> fun(DataNode<V> node) {
                return node.getDataNode(key);
            }
        });
    }

    public static <K, V> Map<K, List<V>> groupBy(Collection<V> nodes, NullableFunction<V, K> grouper) {
        HashMap result = ContainerUtilRt.newHashMap();
        for (V data : nodes) {
            Object key = grouper.fun(data);
            if (key == null) {
                LOG.warn(String.format("Skipping entry '%s' during grouping. Reason: it's not possible to build a grouping key with grouping strategy '%s'. Given entries: %s", data, grouper.getClass(), nodes));
                continue;
            }
            List grouped = (List)result.get(key);
            if (grouped == null) {
                grouped = ContainerUtilRt.newArrayList();
                result.put(key, grouped);
            }
            grouped.add(data);
        }
        if (!result.isEmpty() && result.keySet().iterator().next() instanceof Comparable) {
            ArrayList ordered = ContainerUtilRt.newArrayList(result.keySet());
            Collections.sort(ordered, COMPARABLE_GLUE);
            LinkedHashMap orderedResult = ContainerUtilRt.newLinkedHashMap();
            for (Object k : ordered) {
                orderedResult.put(k, result.get(k));
            }
            return orderedResult;
        }
        return result;
    }

    public static <T> Collection<DataNode<T>> getChildren(DataNode<?> node, Key<T> key) {
        ArrayList result = null;
        for (DataNode<?> child : node.getChildren()) {
            if (!key.equals(child.getKey())) continue;
            if (result == null) {
                result = ContainerUtilRt.newArrayList();
            }
            result.add(child);
        }
        return result == null ? Collections.emptyList() : result;
    }

    public static <T> DataNode<T> find(DataNode<?> node, Key<T> key) {
        for (DataNode<?> child : node.getChildren()) {
            if (!key.equals(child.getKey())) continue;
            return child;
        }
        return null;
    }

    public static <T> DataNode<T> find(DataNode<?> node, Key<T> key, BooleanFunction<DataNode<T>> predicate) {
        for (DataNode<?> child : node.getChildren()) {
            if (!key.equals(child.getKey()) || !predicate.fun(child)) continue;
            return child;
        }
        return null;
    }

    public static <T> DataNode<T> findParent(DataNode<?> node, Key<T> key) {
        return ExternalSystemApiUtil.findParent(node, key, null);
    }

    public static <T> DataNode<T> findParent(DataNode<?> node, Key<T> key, BooleanFunction<DataNode<T>> predicate) {
        DataNode<?> parent = node.getParent();
        if (parent == null) {
            return null;
        }
        return key.equals(parent.getKey()) && (predicate == null || predicate.fun(parent)) ? parent : ExternalSystemApiUtil.findParent(parent, key, predicate);
    }

    public static <T> Collection<DataNode<T>> findAll(DataNode<?> parent, Key<T> key) {
        ArrayList result = null;
        for (DataNode<?> child : parent.getChildren()) {
            if (!key.equals(child.getKey())) continue;
            if (result == null) {
                result = ContainerUtilRt.newArrayList();
            }
            result.add(child);
        }
        return result == null ? Collections.emptyList() : result;
    }

    public static void visit(DataNode node, Consumer<DataNode> consumer) {
        if (node == null) {
            return;
        }
        Stack toProcess = ContainerUtil.newStack((Object[])new DataNode[]{node});
        while (!toProcess.isEmpty()) {
            DataNode node0 = (DataNode)toProcess.pop();
            consumer.consume((Object)node0);
            for (DataNode<?> child : node0.getChildren()) {
                toProcess.push(child);
            }
        }
    }

    public static <T> Collection<DataNode<T>> findAllRecursively(DataNode<?> node, final Key<T> key) {
        if (node == null) {
            return Collections.emptyList();
        }
        Collection<DataNode<?>> nodes = ExternalSystemApiUtil.findAllRecursively(node.getChildren(), new BooleanFunction<DataNode<?>>(){

            public boolean fun(DataNode<?> node) {
                return node.getKey().equals(key);
            }
        });
        return new SmartList(nodes);
    }

    public static Collection<DataNode<?>> findAllRecursively(Collection<DataNode<?>> nodes) {
        return ExternalSystemApiUtil.findAllRecursively(nodes, null);
    }

    public static Collection<DataNode<?>> findAllRecursively(DataNode<?> node, BooleanFunction<DataNode<?>> predicate) {
        if (node == null) {
            return Collections.emptyList();
        }
        return ExternalSystemApiUtil.findAllRecursively(node.getChildren(), predicate);
    }

    public static Collection<DataNode<?>> findAllRecursively(Collection<DataNode<?>> nodes, BooleanFunction<DataNode<?>> predicate) {
        SmartList result = new SmartList();
        for (DataNode<?> node : nodes) {
            if (predicate != null && !predicate.fun(node)) continue;
            result.add(node);
        }
        for (DataNode<?> node : nodes) {
            result.addAll(ExternalSystemApiUtil.findAllRecursively(node.getChildren(), predicate));
        }
        return result;
    }

    public static DataNode<?> findFirstRecursively(DataNode<?> parentNode, BooleanFunction<DataNode<?>> predicate) {
        LinkedList queue = new LinkedList();
        queue.add(parentNode);
        return ExternalSystemApiUtil.findInQueue(queue, predicate);
    }

    public static DataNode<?> findFirstRecursively(Collection<DataNode<?>> nodes, BooleanFunction<DataNode<?>> predicate) {
        return ExternalSystemApiUtil.findInQueue(new LinkedList(nodes), predicate);
    }

    private static DataNode<?> findInQueue(Queue<DataNode<?>> queue, BooleanFunction<DataNode<?>> predicate) {
        while (!queue.isEmpty()) {
            DataNode<?> node = queue.remove();
            if (predicate.fun(node)) {
                return node;
            }
            queue.addAll(node.getChildren());
        }
        return null;
    }

    public static void executeProjectChangeAction(DisposeAwareProjectChange task) {
        ExternalSystemApiUtil.executeProjectChangeAction(false, task);
    }

    public static void executeProjectChangeAction(boolean synchronous, final DisposeAwareProjectChange task) {
        ExternalSystemApiUtil.executeOnEdt(synchronous, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        task.run();
                    }
                });
            }
        });
    }

    public static void executeOnEdt(boolean synchronous, Runnable task) {
        if (synchronous) {
            if (ApplicationManager.getApplication().isDispatchThread()) {
                task.run();
            } else {
                UIUtil.invokeAndWaitIfNeeded((Runnable)task);
            }
        } else {
            UIUtil.invokeLaterIfNeeded((Runnable)task);
        }
    }

    public static <T> T executeOnEdt(Computable<T> task) {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            return (T)task.compute();
        }
        return (T)UIUtil.invokeAndWaitIfNeeded(task);
    }

    public static <T> T executeOnEdtUnderWriteAction(final Computable<T> task) {
        return ExternalSystemApiUtil.executeOnEdt(new Computable<T>(){

            public T compute() {
                return ApplicationManager.getApplication().runWriteAction(task);
            }
        });
    }

    public static void addToInvokeLater(Runnable runnable) {
        Application application = ApplicationManager.getApplication();
        boolean unitTestMode = application.isUnitTestMode();
        if (unitTestMode) {
            UIUtil.invokeLaterIfNeeded((Runnable)runnable);
        } else if (application.isHeadlessEnvironment() || application.isDispatchThread()) {
            runnable.run();
        } else {
            TRANSFER_TO_EDT_QUEUE.offer((Object)runnable);
        }
    }

    public static void addBundle(PathsList classPath, String bundlePath, Class<?> contextClass) {
        String root;
        String pathToUse = bundlePath.replace('.', '/');
        if (!pathToUse.endsWith(".properties")) {
            pathToUse = pathToUse + ".properties";
        }
        if (!pathToUse.startsWith(PATH_SEPARATOR)) {
            pathToUse = '/' + pathToUse;
        }
        if ((root = PathManager.getResourceRoot(contextClass, (String)pathToUse)) != null) {
            classPath.add(root);
        }
    }

    public static String normalizePath(String s) {
        return StringUtil.isEmpty((String)s) ? null : s.replace('\\', '/');
    }

    public static boolean isNewProjectConstruction() {
        return ProjectManager.getInstance().getOpenProjects().length == 0;
    }

    public static void storeLastUsedExternalProjectPath(String path, ProjectSystemId externalSystemId) {
        if (path != null) {
            PropertiesComponent.getInstance().setValue(LAST_USED_PROJECT_PATH_PREFIX + externalSystemId.getReadableName(), path);
        }
    }

    public static String getProjectRepresentationName(String targetProjectPath, String rootProjectPath) {
        File targetProjectDir;
        if (rootProjectPath == null) {
            File rootProjectDir = new File(targetProjectPath);
            if (rootProjectDir.isFile()) {
                rootProjectDir = rootProjectDir.getParentFile();
            }
            return rootProjectDir.getName();
        }
        File rootProjectDir = new File(rootProjectPath);
        if (rootProjectDir.isFile()) {
            rootProjectDir = rootProjectDir.getParentFile();
        }
        if ((targetProjectDir = new File(targetProjectPath)).isFile()) {
            targetProjectDir = targetProjectDir.getParentFile();
        }
        StringBuilder buffer = new StringBuilder();
        for (File f = targetProjectDir; f != null && !FileUtil.filesEqual((File)f, (File)rootProjectDir); f = f.getParentFile()) {
            buffer.insert(0, f.getName()).insert(0, ":");
        }
        buffer.insert(0, rootProjectDir.getName());
        return buffer.toString();
    }

    public static String getRootProjectPath(String externalProjectPath, ProjectSystemId externalSystemId, Project project) {
        ExternalSystemManager<?, ?, ?, ?, ?> manager = ExternalSystemApiUtil.getManager(externalSystemId);
        if (manager == null) {
            return null;
        }
        if (manager instanceof ExternalSystemAutoImportAware) {
            return ((ExternalSystemAutoImportAware)((Object)manager)).getAffectedExternalProjectPath(externalProjectPath, project);
        }
        return null;
    }

    public static String buildErrorMessage(Throwable e) {
        Throwable unwrapped = RemoteUtil.unwrap((Throwable)e);
        String reason = unwrapped.getLocalizedMessage();
        if (!StringUtil.isEmpty((String)reason)) {
            return reason;
        }
        if (unwrapped.getClass() == ExternalSystemException.class) {
            return String.format("exception during working with external system: %s", ((ExternalSystemException)unwrapped).getOriginalReason());
        }
        StringWriter writer = new StringWriter();
        unwrapped.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    public static AbstractExternalSystemSettings getSettings(Project project, ProjectSystemId externalSystemId) throws IllegalArgumentException {
        ExternalSystemManager<?, ?, ?, ?, ?> manager = ExternalSystemApiUtil.getManager(externalSystemId);
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Can't retrieve external system settings for id '%s'. Reason: no such external system is registered", externalSystemId.getReadableName()));
        }
        return (AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)project);
    }

    public static <S extends AbstractExternalSystemLocalSettings> S getLocalSettings(Project project, ProjectSystemId externalSystemId) throws IllegalArgumentException {
        ExternalSystemManager<?, ?, ?, ?, ?> manager = ExternalSystemApiUtil.getManager(externalSystemId);
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Can't retrieve local external system settings for id '%s'. Reason: no such external system is registered", externalSystemId.getReadableName()));
        }
        return (S)((AbstractExternalSystemLocalSettings)manager.getLocalSettingsProvider().fun((Object)project));
    }

    public static <S extends ExternalSystemExecutionSettings> S getExecutionSettings(Project project, String linkedProjectPath, ProjectSystemId externalSystemId) throws IllegalArgumentException {
        ExternalSystemManager<?, ?, ?, ?, ?> manager = ExternalSystemApiUtil.getManager(externalSystemId);
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Can't retrieve external system execution settings for id '%s'. Reason: no such external system is registered", externalSystemId.getReadableName()));
        }
        return (S)((ExternalSystemExecutionSettings)manager.getExecutionSettingsProvider().fun((Object)Pair.create((Object)project, (Object)linkedProjectPath)));
    }

    public static boolean isInProcessMode(ProjectSystemId externalSystemId) {
        return Registry.is((String)(externalSystemId.getId() + ".system.in.process"), (boolean)false);
    }

    public static <T extends ParametersEnhancer> T reloadIfNecessary(final Class<T> clazz) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException, ClassNotFoundException {
        ParametersEnhancer instance = (ParametersEnhancer)clazz.newInstance();
        ArrayList urls = ContainerUtilRt.newArrayList();
        instance.enhanceLocalProcessing(urls);
        if (urls.isEmpty()) {
            return (T)instance;
        }
        final ClassLoader baseLoader = clazz.getClassLoader();
        Method method = baseLoader.getClass().getMethod("getUrls", new Class[0]);
        if (method != null) {
            urls.addAll((Collection)method.invoke((Object)baseLoader, new Object[0]));
        }
        UrlClassLoader loader = new UrlClassLoader(UrlClassLoader.build().urls((List)urls).parent(baseLoader.getParent())){

            protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                if (name.equals(clazz.getName())) {
                    return super.loadClass(name, resolve);
                }
                try {
                    return baseLoader.loadClass(name);
                }
                catch (ClassNotFoundException e) {
                    return super.loadClass(name, resolve);
                }
            }
        };
        return (T)((ParametersEnhancer)loader.loadClass(clazz.getName()).newInstance());
    }

    public static boolean isExternalSystemAwareModule(ProjectSystemId systemId, Module module) {
        return module != null && !module.isDisposed() && systemId.getId().equals(module.getOptionValue("external.system.id"));
    }

    public static boolean isExternalSystemAwareModule(String systemId, Module module) {
        return module != null && !module.isDisposed() && systemId.equals(module.getOptionValue("external.system.id"));
    }

    public static String getExternalProjectPath(Module module) {
        return module != null && !module.isDisposed() ? module.getOptionValue("external.linked.project.path") : null;
    }

    public static String getExternalRootProjectPath(Module module) {
        return module != null && !module.isDisposed() ? module.getOptionValue("external.root.project.path") : null;
    }

    public static String getExternalProjectId(Module module) {
        return module != null && !module.isDisposed() ? module.getOptionValue("external.linked.project.id") : null;
    }

    public static String getExternalProjectGroup(Module module) {
        return module != null && !module.isDisposed() ? module.getOptionValue("external.system.module.group") : null;
    }

    public static String getExternalProjectVersion(Module module) {
        return module != null && !module.isDisposed() ? module.getOptionValue("external.system.module.version") : null;
    }

    public static void subscribe(Project project, ProjectSystemId systemId, ExternalSystemSettingsListener listener) {
        ExternalSystemApiUtil.getSettings(project, systemId).subscribe(listener);
    }
}

