/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.util;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.project.Project;

public class IntegrationKey {
    private final String myIdeProjectName;
    private final String myIdeProjectLocationHash;
    private final ProjectSystemId myExternalSystemId;
    private final String myExternalProjectConfigPath;

    public IntegrationKey(Project ideProject, ProjectSystemId externalSystemId, String externalProjectConfigPath) {
        this(ideProject.getName(), ideProject.getLocationHash(), externalSystemId, externalProjectConfigPath);
    }

    public IntegrationKey(String ideProjectName, String ideProjectLocationHash, ProjectSystemId externalSystemId, String externalProjectConfigPath) {
        this.myIdeProjectName = ideProjectName;
        this.myIdeProjectLocationHash = ideProjectLocationHash;
        this.myExternalSystemId = externalSystemId;
        this.myExternalProjectConfigPath = externalProjectConfigPath;
    }

    public String getIdeProjectName() {
        return this.myIdeProjectName;
    }

    public String getIdeProjectLocationHash() {
        return this.myIdeProjectLocationHash;
    }

    public ProjectSystemId getExternalSystemId() {
        return this.myExternalSystemId;
    }

    public String getExternalProjectConfigPath() {
        return this.myExternalProjectConfigPath;
    }

    public int hashCode() {
        int result = this.myIdeProjectName.hashCode();
        result = 31 * result + this.myIdeProjectLocationHash.hashCode();
        result = 31 * result + this.myExternalSystemId.hashCode();
        result = 31 * result + this.myExternalProjectConfigPath.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntegrationKey key = (IntegrationKey)o;
        if (!this.myExternalSystemId.equals(key.myExternalSystemId)) {
            return false;
        }
        if (!this.myIdeProjectLocationHash.equals(key.myIdeProjectLocationHash)) {
            return false;
        }
        if (!this.myIdeProjectName.equals(key.myIdeProjectName)) {
            return false;
        }
        return this.myExternalProjectConfigPath.equals(key.myExternalProjectConfigPath);
    }

    public String toString() {
        return String.format("%s project '%s'", this.myExternalSystemId.toString().toLowerCase(), this.myIdeProjectName);
    }
}

