/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.PathChooserDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import java.awt.Component;
import java.util.List;

public class FileChooser {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.fileChooser.FileChooser");

    private FileChooser() {
    }

    public static VirtualFile[] chooseFiles(FileChooserDescriptor descriptor, Project project, VirtualFile toSelect) {
        return FileChooser.chooseFiles(descriptor, null, project, toSelect);
    }

    public static VirtualFile[] chooseFiles(FileChooserDescriptor descriptor, Component parent, Project project, VirtualFile toSelect) {
        FileChooserDialog chooser = FileChooserFactory.getInstance().createFileChooser(descriptor, project, parent);
        return chooser.choose(project, toSelect);
    }

    public static VirtualFile chooseFile(FileChooserDescriptor descriptor, Project project, VirtualFile toSelect) {
        return FileChooser.chooseFile(descriptor, null, project, toSelect);
    }

    public static VirtualFile chooseFile(FileChooserDescriptor descriptor, Component parent, Project project, VirtualFile toSelect) {
        LOG.assertTrue(!descriptor.isChooseMultiple());
        return (VirtualFile)ArrayUtil.getFirstElement((Object[])FileChooser.chooseFiles(descriptor, parent, project, toSelect));
    }

    public static void chooseFiles(FileChooserDescriptor descriptor, Project project, VirtualFile toSelect, Consumer<List<VirtualFile>> callback) {
        FileChooser.chooseFiles(descriptor, project, null, toSelect, callback);
    }

    public static void chooseFiles(FileChooserDescriptor descriptor, Project project, Component parent, VirtualFile toSelect, Consumer<List<VirtualFile>> callback) {
        FileChooserFactory factory = FileChooserFactory.getInstance();
        PathChooserDialog pathChooser = factory.createPathChooser(descriptor, project, parent);
        pathChooser.choose(toSelect, callback);
    }

    public static void chooseFile(FileChooserDescriptor descriptor, Project project, VirtualFile toSelect, Consumer<VirtualFile> callback) {
        FileChooser.chooseFile(descriptor, project, null, toSelect, callback);
    }

    public static void chooseFile(FileChooserDescriptor descriptor, Project project, Component parent, VirtualFile toSelect, final Consumer<VirtualFile> callback) {
        LOG.assertTrue(!descriptor.isChooseMultiple());
        FileChooser.chooseFiles(descriptor, project, parent, toSelect, new Consumer<List<VirtualFile>>(){

            public void consume(List<VirtualFile> files) {
                callback.consume((Object)files.get(0));
            }
        });
    }

    public static interface FileChooserConsumer
    extends Consumer<List<VirtualFile>> {
        public void cancelled();
    }
}

