/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser;

import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.UIBundle;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;

public class FileChooserDescriptor
implements Cloneable {
    private final boolean myChooseFiles;
    private final boolean myChooseFolders;
    private final boolean myChooseJars;
    private final boolean myChooseJarsAsFiles;
    private final boolean myChooseJarContents;
    private final boolean myChooseMultiple;
    private String myTitle = UIBundle.message((String)"file.chooser.default.title", (Object[])new Object[0]);
    private String myDescription;
    private boolean myHideIgnored = true;
    private final List<VirtualFile> myRoots = new ArrayList<VirtualFile>();
    private boolean myShowFileSystemRoots = true;
    private boolean myTreeRootVisible = false;
    private boolean myShowHiddenFiles = false;
    private Condition<VirtualFile> myFileFilter = null;
    private final Map<String, Object> myUserData = new HashMap<String, Object>();

    public FileChooserDescriptor(boolean chooseFiles, boolean chooseFolders, boolean chooseJars, boolean chooseJarsAsFiles, boolean chooseJarContents, boolean chooseMultiple) {
        this.myChooseFiles = chooseFiles;
        this.myChooseFolders = chooseFolders;
        this.myChooseJars = chooseJars;
        this.myChooseJarsAsFiles = chooseJarsAsFiles;
        this.myChooseJarContents = chooseJarContents;
        this.myChooseMultiple = chooseMultiple;
    }

    public FileChooserDescriptor(FileChooserDescriptor d) {
        this(d.isChooseFiles(), d.isChooseFolders(), d.isChooseJars(), d.isChooseJarsAsFiles(), d.isChooseJarContents(), d.isChooseMultiple());
        this.withTitle(d.getTitle());
        this.withDescription(d.getDescription());
        this.withHideIgnored(d.isHideIgnored());
        this.withRoots(d.getRoots());
        this.withShowFileSystemRoots(d.isShowFileSystemRoots());
        this.withTreeRootVisible(d.isTreeRootVisible());
        this.withShowHiddenFiles(d.isShowHiddenFiles());
    }

    public boolean isChooseFiles() {
        return this.myChooseFiles;
    }

    public boolean isChooseFolders() {
        return this.myChooseFolders;
    }

    public boolean isChooseJars() {
        return this.myChooseJars;
    }

    public boolean isChooseJarsAsFiles() {
        return this.myChooseJarsAsFiles;
    }

    public boolean isChooseJarContents() {
        return this.myChooseJarContents;
    }

    public boolean isChooseMultiple() {
        return this.myChooseMultiple;
    }

    public boolean getChooseMultiple() {
        return this.isChooseMultiple();
    }

    public String getTitle() {
        return this.myTitle;
    }

    public void setTitle(String title) {
        this.withTitle(title);
    }

    public FileChooserDescriptor withTitle(String title) {
        this.myTitle = title;
        return this;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(String description) {
        this.withDescription(description);
    }

    public FileChooserDescriptor withDescription(String description) {
        this.myDescription = description;
        return this;
    }

    public boolean isHideIgnored() {
        return this.myHideIgnored;
    }

    public void setHideIgnored(boolean hideIgnored) {
        this.withHideIgnored(hideIgnored);
    }

    public FileChooserDescriptor withHideIgnored(boolean hideIgnored) {
        this.myHideIgnored = hideIgnored;
        return this;
    }

    public List<VirtualFile> getRoots() {
        return Collections.unmodifiableList(this.myRoots);
    }

    public void setRoots(VirtualFile ... roots) {
        this.withRoots(roots);
    }

    public void setRoots(List<VirtualFile> roots) {
        this.withRoots(roots);
    }

    public FileChooserDescriptor withRoots(VirtualFile ... roots) {
        return this.withRoots(Arrays.asList(roots));
    }

    public FileChooserDescriptor withRoots(List<VirtualFile> roots) {
        this.myRoots.clear();
        this.myRoots.addAll(roots);
        return this;
    }

    public boolean isShowFileSystemRoots() {
        return this.myShowFileSystemRoots;
    }

    public void setShowFileSystemRoots(boolean showFileSystemRoots) {
        this.withShowFileSystemRoots(showFileSystemRoots);
    }

    public FileChooserDescriptor withShowFileSystemRoots(boolean showFileSystemRoots) {
        this.myShowFileSystemRoots = showFileSystemRoots;
        return this;
    }

    public boolean isTreeRootVisible() {
        return this.myTreeRootVisible;
    }

    public FileChooserDescriptor withTreeRootVisible(boolean isTreeRootVisible) {
        this.myTreeRootVisible = isTreeRootVisible;
        return this;
    }

    public FileChooserDescriptor setIsTreeRootVisible(boolean treeRootVisible) {
        return this.withTreeRootVisible(treeRootVisible);
    }

    public boolean isShowHiddenFiles() {
        return this.myShowHiddenFiles;
    }

    public FileChooserDescriptor withShowHiddenFiles(boolean showHiddenFiles) {
        this.myShowHiddenFiles = showHiddenFiles;
        return this;
    }

    public FileChooserDescriptor withFileFilter(Condition<VirtualFile> filter) {
        this.myFileFilter = filter;
        return this;
    }

    public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
        if (file.is(VFileProperty.SYMLINK) && file.getCanonicalPath() == null) {
            return false;
        }
        if (!file.isDirectory()) {
            if (FileElement.isArchive(file) ? !this.myChooseJars && !this.myChooseJarContents : !this.myChooseFiles) {
                return false;
            }
            if (this.myFileFilter != null && !this.myFileFilter.value((Object)file)) {
                return false;
            }
        }
        if (this.isHideIgnored() && FileTypeManager.getInstance().isFileIgnored(file)) {
            return false;
        }
        return showHiddenFiles || !FileElement.isFileHidden(file);
    }

    public boolean isFileSelectable(VirtualFile file) {
        if (file == null) {
            return false;
        }
        if (file.is(VFileProperty.SYMLINK) && file.getCanonicalPath() == null) {
            return false;
        }
        if (file.isDirectory() && this.myChooseFolders) {
            return true;
        }
        if (this.acceptAsJarFile(file)) {
            return true;
        }
        if (this.acceptAsGeneralFile(file)) {
            return true;
        }
        return this.myFileFilter != null && !file.isDirectory() && this.myFileFilter.value((Object)file);
    }

    public Icon getIcon(VirtualFile file) {
        if (file.isDirectory()) {
            return FileChooserDescriptor.dressIcon(file, PlatformIcons.DIRECTORY_CLOSED_ICON);
        }
        return IconUtil.getIcon(file, 2, null);
    }

    protected static Icon dressIcon(VirtualFile file, Icon baseIcon) {
        return file.isValid() && file.is(VFileProperty.SYMLINK) ? new LayeredIcon(baseIcon, PlatformIcons.SYMLINK_ICON) : baseIcon;
    }

    public String getName(VirtualFile file) {
        return file.getPath();
    }

    public String getComment(VirtualFile file) {
        return null;
    }

    public void validateSelectedFiles(VirtualFile[] files) throws Exception {
    }

    private boolean acceptAsGeneralFile(VirtualFile file) {
        if (FileElement.isArchive(file)) {
            return false;
        }
        return !file.isDirectory() && this.myChooseFiles;
    }

    private boolean acceptAsJarFile(VirtualFile file) {
        return this.myChooseJars && FileElement.isArchive(file);
    }

    public final VirtualFile getFileToSelect(VirtualFile file) {
        boolean isJar;
        if (file.isDirectory() && (this.myChooseFolders || this.isFileSelectable(file))) {
            return file;
        }
        boolean bl = isJar = file.getFileType() == FileTypes.ARCHIVE;
        if (!isJar) {
            return this.acceptAsGeneralFile(file) ? file : null;
        }
        if (this.myChooseJarsAsFiles) {
            return file;
        }
        if (!this.acceptAsJarFile(file)) {
            return null;
        }
        String path = file.getPath();
        return JarFileSystem.getInstance().findFileByPath(path + "!/");
    }

    public final Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public Object getUserData(String dataId) {
        return this.myUserData.get(dataId);
    }

    public <T> T getUserData(DataKey<T> key) {
        Object t = this.myUserData.get(key.getName());
        return (T)t;
    }

    public <T> void putUserData(DataKey<T> key, T data) {
        this.myUserData.put(key.getName(), data);
    }

    public String toString() {
        return "FileChooserDescriptor [" + this.myTitle + "]";
    }
}

