/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.openapi.fileTypes.FileNameMatcherEx;
import com.intellij.openapi.util.Comparing;
import org.jetbrains.annotations.NonNls;

public class ExactFileNameMatcher
extends FileNameMatcherEx {
    private final String myFileName;
    private final boolean myIgnoreCase;

    public ExactFileNameMatcher(@NonNls String fileName) {
        this.myFileName = fileName;
        this.myIgnoreCase = false;
    }

    public ExactFileNameMatcher(@NonNls String fileName, boolean ignoreCase) {
        this.myFileName = fileName;
        this.myIgnoreCase = ignoreCase;
    }

    @Override
    public boolean acceptsCharSequence(@NonNls CharSequence fileName) {
        return Comparing.equal((CharSequence)fileName, (CharSequence)this.myFileName, (!this.myIgnoreCase ? 1 : 0) != 0);
    }

    @Override
    @NonNls
    public String getPresentableString() {
        return this.myFileName;
    }

    public String getFileName() {
        return this.myFileName;
    }

    public boolean isIgnoreCase() {
        return this.myIgnoreCase;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExactFileNameMatcher that = (ExactFileNameMatcher)o;
        return this.myFileName.equals(that.myFileName);
    }

    public int hashCode() {
        return this.myFileName.hashCode();
    }

    public String toString() {
        return this.getPresentableString();
    }
}

