/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.fileTypes.INativeFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import javax.swing.Icon;

public class NativeFileType
implements INativeFileType {
    public static final NativeFileType INSTANCE = new NativeFileType();

    private NativeFileType() {
    }

    @Override
    public String getName() {
        return "Native";
    }

    @Override
    public String getDescription() {
        return "Files opened in associated applications";
    }

    @Override
    public String getDefaultExtension() {
        return "";
    }

    @Override
    public Icon getIcon() {
        return AllIcons.FileTypes.Custom;
    }

    @Override
    public boolean isBinary() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String getCharset(VirtualFile file, byte[] content) {
        return null;
    }

    @Override
    public boolean openFileInAssociatedApplication(Project project, VirtualFile file) {
        return NativeFileType.openAssociatedApplication(file);
    }

    @Override
    public boolean useNativeIcon() {
        return true;
    }

    public static boolean openAssociatedApplication(VirtualFile file) {
        ArrayList<String> commands = new ArrayList<String>();
        if (SystemInfo.isWindows) {
            commands.add("rundll32.exe");
            commands.add("url.dll,FileProtocolHandler");
        } else if (SystemInfo.isMac) {
            commands.add("/usr/bin/open");
        } else if (SystemInfo.hasXdgOpen()) {
            commands.add("xdg-open");
        } else {
            return false;
        }
        commands.add(file.getPath());
        try {
            new GeneralCommandLine(commands).createProcess();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

