/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module;

import com.intellij.ide.util.frameworkSupport.FrameworkRole;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public abstract class ModuleType<T extends ModuleBuilder> {
    public static final ModuleType EMPTY = ModuleType.instantiate("com.intellij.openapi.module.EmptyModuleType");
    private final String myId;
    private final FrameworkRole myFrameworkRole;

    protected ModuleType(@NonNls String id) {
        this.myId = id;
        this.myFrameworkRole = new FrameworkRole(id);
    }

    public abstract T createModuleBuilder();

    public abstract String getName();

    public abstract String getDescription();

    public abstract Icon getBigIcon();

    public Icon getIcon() {
        return this.getNodeIcon(false);
    }

    public abstract Icon getNodeIcon(@Deprecated boolean var1);

    public ModuleWizardStep[] createWizardSteps(WizardContext wizardContext, T moduleBuilder, ModulesProvider modulesProvider) {
        return ModuleWizardStep.EMPTY_ARRAY;
    }

    public ModuleWizardStep modifySettingsStep(SettingsStep settingsStep, ModuleBuilder moduleBuilder) {
        return null;
    }

    public ModuleWizardStep modifyProjectTypeStep(SettingsStep settingsStep, ModuleBuilder moduleBuilder) {
        return null;
    }

    public final String getId() {
        return this.myId;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModuleType)) {
            return false;
        }
        ModuleType moduleType = (ModuleType)o;
        return this.myId.equals(moduleType.myId);
    }

    public final int hashCode() {
        return this.myId.hashCode();
    }

    public String toString() {
        return this.getName();
    }

    private static ModuleType instantiate(String className) {
        try {
            return (ModuleType)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public boolean isValidSdk(Module module, Sdk projectSdk) {
        return true;
    }

    public static ModuleType get(Module module) {
        ModuleTypeManager instance = ModuleTypeManager.getInstance();
        if (instance == null) {
            return EMPTY;
        }
        return instance.findByID(module.getOptionValue("type"));
    }

    public FrameworkRole getDefaultAcceptableRole() {
        return this.myFrameworkRole;
    }

    public boolean isSupportedRootType(JpsModuleSourceRootType type) {
        return true;
    }
}

