/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeExtensionProvider;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.util.InvalidDataException;
import java.io.IOException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;

public abstract class BaseSchemeProcessor<T extends ExternalizableScheme>
implements SchemeProcessor<T>,
SchemeExtensionProvider {
    @Override
    public void initScheme(T scheme) {
    }

    @Override
    public void onSchemeAdded(T scheme) {
    }

    @Override
    public void onSchemeDeleted(T scheme) {
    }

    @Override
    public void onCurrentSchemeChanged(Scheme newCurrentScheme) {
    }

    public T readScheme(Element element) throws InvalidDataException, IOException, JDOMException {
        return this.readScheme(new Document((Element)element.detach()));
    }

    public T readScheme(Element element, boolean duringLoad) throws InvalidDataException, IOException, JDOMException {
        return this.readScheme(element);
    }

    @Override
    public T readScheme(Document schemeContent) throws InvalidDataException, IOException, JDOMException {
        throw new AbstractMethodError();
    }

    @Override
    public boolean shouldBeSaved(T scheme) {
        return true;
    }

    public State getState(T scheme) {
        return this.shouldBeSaved(scheme) ? State.POSSIBLY_CHANGED : State.NON_PERSISTENT;
    }

    @Override
    public boolean isUpgradeNeeded() {
        return false;
    }

    @Override
    public String getSchemeExtension() {
        return ".xml";
    }

    public static enum State {
        UNCHANGED,
        NON_PERSISTENT,
        POSSIBLY_CHANGED;

    }
}

