/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.paths;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.paths.PathReferenceProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.ArrayList;

public abstract class PathReferenceManager {
    public static final ExtensionPointName<PathReferenceProvider> PATH_REFERENCE_PROVIDER_EP = ExtensionPointName.create((String)"com.intellij.pathReferenceProvider");
    public static final ExtensionPointName<PathReferenceProvider> ANCHOR_REFERENCE_PROVIDER_EP = ExtensionPointName.create((String)"com.intellij.anchorReferenceProvider");

    public static PathReferenceManager getInstance() {
        return ServiceManager.getService(PathReferenceManager.class);
    }

    public abstract PsiReference[] createReferences(PsiElement var1, boolean var2, PathReferenceProvider ... var3);

    public abstract PsiReference[] createReferences(PsiElement var1, boolean var2, boolean var3, boolean var4, PathReferenceProvider ... var5);

    public abstract PsiReference[] createReferences(PsiElement var1, boolean var2, boolean var3, boolean var4, FileType[] var5, PathReferenceProvider ... var6);

    public abstract PsiReference[] createCustomReferences(PsiElement var1, boolean var2, PathReferenceProvider ... var3);

    public abstract PathReference getPathReference(String var1, PsiElement var2, PathReferenceProvider ... var3);

    public abstract PathReference getCustomPathReference(String var1, Module var2, PsiElement var3, PathReferenceProvider ... var4);

    public abstract PathReferenceProvider getGlobalWebPathReferenceProvider();

    public abstract PathReferenceProvider createStaticPathReferenceProvider(boolean var1);

    public static PsiReference[] getReferencesFromProvider(PathReferenceProvider provider, PsiElement psiElement, boolean soft) {
        ArrayList<PsiReference> references = new ArrayList<PsiReference>();
        provider.createReferences(psiElement, references, soft);
        return references.toArray(new PsiReference[references.size()]);
    }
}

