/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ThrowableComputable;
import javax.swing.JComponent;

public abstract class ProgressManager
extends ProgressIndicatorProvider {
    public static ProgressManager getInstance() {
        return ProgressManagerHolder.ourInstance;
    }

    public abstract boolean hasProgressIndicator();

    public abstract boolean hasModalProgressIndicator();

    public abstract boolean hasUnsafeProgressIndicator();

    public abstract void runProcess(Runnable var1, ProgressIndicator var2) throws ProcessCanceledException;

    public abstract <T> T runProcess(Computable<T> var1, ProgressIndicator var2) throws ProcessCanceledException;

    @Override
    public ProgressIndicator getProgressIndicator() {
        return null;
    }

    public static void progress(String text) throws ProcessCanceledException {
        ProgressManager.progress(text, "");
    }

    public static void progress2(String text) throws ProcessCanceledException {
        ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
        if (pi != null) {
            pi.checkCanceled();
            pi.setText2(text);
        }
    }

    public static void progress(String text, String text2) throws ProcessCanceledException {
        ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
        if (pi != null) {
            pi.checkCanceled();
            pi.setText(text);
            pi.setText2(text2 == null ? "" : text2);
        }
    }

    public abstract void executeNonCancelableSection(Runnable var1);

    public abstract void setCancelButtonText(String var1);

    public abstract boolean runProcessWithProgressSynchronously(Runnable var1, String var2, boolean var3, Project var4);

    public abstract <T, E extends Exception> T runProcessWithProgressSynchronously(ThrowableComputable<T, E> var1, String var2, boolean var3, Project var4) throws E;

    public abstract boolean runProcessWithProgressSynchronously(Runnable var1, String var2, boolean var3, Project var4, JComponent var5);

    public abstract void runProcessWithProgressAsynchronously(Project var1, String var2, Runnable var3, Runnable var4, Runnable var5);

    public abstract void runProcessWithProgressAsynchronously(Project var1, String var2, Runnable var3, Runnable var4, Runnable var5, PerformInBackgroundOption var6);

    public abstract void run(Task var1);

    public abstract void runProcessWithProgressAsynchronously(Task.Backgroundable var1, ProgressIndicator var2);

    protected void indicatorCanceled(ProgressIndicator indicator) {
    }

    public static void canceled(ProgressIndicator indicator) {
        ProgressManager.getInstance().indicatorCanceled(indicator);
    }

    public static void checkCanceled() throws ProcessCanceledException {
        ProgressManager.getInstance().doCheckCanceled();
    }

    public abstract void executeProcessUnderProgress(Runnable var1, ProgressIndicator var2) throws ProcessCanceledException;

    private static class ProgressManagerHolder {
        private static final ProgressManager ourInstance = ServiceManager.getService(ProgressManager.class);

        private ProgressManagerHolder() {
        }
    }
}

