/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress;

import com.intellij.CommonBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Progressive;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.project.DumbModeAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;

public abstract class Task
implements TaskInfo,
Progressive {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.progress.Task");
    protected final Project myProject;
    protected String myTitle;
    private final boolean myCanBeCancelled;
    private String myCancelText = CommonBundle.getCancelButtonText();
    private String myCancelTooltipText = CommonBundle.getCancelButtonText();

    public Task(Project project, String title, boolean canBeCancelled) {
        this.myProject = project;
        this.myTitle = title;
        this.myCanBeCancelled = canBeCancelled;
    }

    public void onCancel() {
    }

    public void onSuccess() {
    }

    public final Project getProject() {
        return this.myProject;
    }

    public final void queue() {
        ProgressManager.getInstance().run(this);
    }

    @Override
    public String getProcessId() {
        return "<unknown>";
    }

    @Override
    public final String getTitle() {
        return this.myTitle;
    }

    public final Task setTitle(String title) {
        this.myTitle = title;
        return this;
    }

    @Override
    public final String getCancelText() {
        return this.myCancelText;
    }

    public final Task setCancelText(String cancelText) {
        this.myCancelText = cancelText;
        return this;
    }

    public NotificationInfo getNotificationInfo() {
        return null;
    }

    public NotificationInfo notifyFinished() {
        return this.getNotificationInfo();
    }

    public boolean isHeadless() {
        return ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment();
    }

    public final Task setCancelTooltipText(String cancelTooltipText) {
        this.myCancelTooltipText = cancelTooltipText;
        return this;
    }

    @Override
    public final String getCancelTooltipText() {
        return this.myCancelTooltipText;
    }

    @Override
    public final boolean isCancellable() {
        return this.myCanBeCancelled;
    }

    public abstract boolean isModal();

    public final Modal asModal() {
        if (this.isModal()) {
            return (Modal)this;
        }
        throw new IllegalStateException("Not a modal task");
    }

    public final Backgroundable asBackgroundable() {
        if (!this.isModal()) {
            return (Backgroundable)this;
        }
        throw new IllegalStateException("Not a backgroundable task");
    }

    public static class NotificationInfo {
        private final String myNotificationName;
        private final String myNotificationTitle;
        private final String myNotificationText;
        private final boolean myShowWhenFocused;

        public NotificationInfo(String notificationName, String notificationTitle, String notificationText) {
            this(notificationName, notificationTitle, notificationText, false);
        }

        public NotificationInfo(String notificationName, String notificationTitle, String notificationText, boolean showWhenFocused) {
            this.myNotificationName = notificationName;
            this.myNotificationTitle = notificationTitle;
            this.myNotificationText = notificationText;
            this.myShowWhenFocused = showWhenFocused;
        }

        public String getNotificationName() {
            return this.myNotificationName;
        }

        public String getNotificationTitle() {
            return this.myNotificationTitle;
        }

        public String getNotificationText() {
            return this.myNotificationText;
        }

        public boolean isShowWhenFocused() {
            return this.myShowWhenFocused;
        }
    }

    public static abstract class ConditionalModal
    extends Backgroundable {
        public ConditionalModal(Project project, String title, boolean canBeCancelled, PerformInBackgroundOption backgroundOption) {
            super(project, title, canBeCancelled, backgroundOption);
        }

        @Override
        public final boolean isConditionalModal() {
            return true;
        }
    }

    public static abstract class Modal
    extends Task {
        public Modal(Project project, String title, boolean canBeCancelled) {
            super(project, title, canBeCancelled);
        }

        @Override
        public final boolean isModal() {
            return true;
        }
    }

    public static abstract class Backgroundable
    extends Task
    implements PerformInBackgroundOption {
        protected final PerformInBackgroundOption myBackgroundOption;

        public Backgroundable(Project project, String title, boolean canBeCancelled, PerformInBackgroundOption backgroundOption) {
            super(project, title, canBeCancelled);
            this.myBackgroundOption = backgroundOption;
            if (StringUtil.isEmptyOrSpaces((String)title)) {
                LOG.warn("Empty title for backgroundable task.", new Throwable());
            }
        }

        public Backgroundable(Project project, String title, boolean canBeCancelled) {
            this(project, title, canBeCancelled, null);
        }

        public Backgroundable(Project project, String title) {
            this(project, title, true);
        }

        @Override
        public boolean shouldStartInBackground() {
            return this.myBackgroundOption == null || this.myBackgroundOption.shouldStartInBackground();
        }

        @Override
        public void processSentToBackground() {
            if (this.myBackgroundOption != null) {
                this.myBackgroundOption.processSentToBackground();
            }
        }

        @Override
        public final boolean isModal() {
            return false;
        }

        public boolean isConditionalModal() {
            return false;
        }

        public DumbModeAction getDumbModeAction() {
            return DumbModeAction.NOTHING;
        }
    }
}

