/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;

public abstract class DumbService {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.project.DumbService");
    public static final Topic<DumbModeListener> DUMB_MODE = new Topic("dumb mode", DumbModeListener.class);
    private static final NotNullLazyKey<DumbService, Project> INSTANCE_KEY = ServiceManager.createLazyKey(DumbService.class);

    public abstract ModificationTracker getModificationTracker();

    public abstract boolean isDumb();

    public static boolean isDumb(Project project) {
        return DumbService.getInstance(project).isDumb();
    }

    public abstract void runWhenSmart(Runnable var1);

    public abstract void waitForSmartMode();

    public <T> T runReadActionInSmartMode(final Computable<T> r) {
        final Ref result = new Ref();
        this.runReadActionInSmartMode(new Runnable(){

            @Override
            public void run() {
                result.set(r.compute());
            }
        });
        return (T)result.get();
    }

    public <T> T tryRunReadActionInSmartMode(Computable<T> task, String notification) {
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            try {
                return (T)task.compute();
            }
            catch (IndexNotReadyException e) {
                if (notification != null) {
                    this.showDumbModeNotification(notification);
                }
                return null;
            }
        }
        return this.runReadActionInSmartMode(task);
    }

    public void runReadActionInSmartMode(final Runnable r) {
        boolean success;
        do {
            this.waitForSmartMode();
        } while (!(success = ApplicationManager.getApplication().runReadAction(new Computable<Boolean>(){

            public Boolean compute() {
                if (DumbService.this.isDumb()) {
                    return false;
                }
                r.run();
                return true;
            }
        }).booleanValue()));
    }

    public void repeatUntilPassesInSmartMode(Runnable r) {
        while (true) {
            this.waitForSmartMode();
            try {
                r.run();
                return;
            }
            catch (IndexNotReadyException e) {
                LOG.info((Throwable)e);
                continue;
            }
            break;
        }
    }

    public abstract void smartInvokeLater(Runnable var1);

    public abstract void smartInvokeLater(Runnable var1, ModalityState var2);

    public static DumbService getInstance(Project project) {
        return (DumbService)INSTANCE_KEY.getValue((UserDataHolder)project);
    }

    public <T> List<T> filterByDumbAwareness(T[] array) {
        return this.filterByDumbAwareness(Arrays.asList(array));
    }

    public <T> List<T> filterByDumbAwareness(Collection<T> collection) {
        if (this.isDumb()) {
            ArrayList<T> result = new ArrayList<T>(collection.size());
            for (T element : collection) {
                if (!DumbService.isDumbAware(element)) continue;
                result.add(element);
            }
            return result;
        }
        if (collection instanceof List) {
            return (List)collection;
        }
        return new ArrayList<T>(collection);
    }

    public abstract void queueTask(DumbModeTask var1);

    public abstract void cancelTask(DumbModeTask var1);

    public abstract JComponent wrapGently(JComponent var1, Disposable var2);

    public void makeDumbAware(final JComponent component, Disposable disposable) {
        component.setEnabled(!this.isDumb());
        this.getProject().getMessageBus().connect(disposable).subscribe(DUMB_MODE, (Object)new DumbModeListener(){

            @Override
            public void enteredDumbMode() {
                component.setEnabled(false);
            }

            @Override
            public void exitDumbMode() {
                component.setEnabled(true);
            }
        });
    }

    public abstract void showDumbModeNotification(String var1);

    public abstract Project getProject();

    public static boolean isDumbAware(Object o) {
        if (o instanceof PossiblyDumbAware) {
            return ((PossiblyDumbAware)o).isDumbAware();
        }
        return o instanceof DumbAware;
    }

    public abstract void setAlternativeResolveEnabled(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withAlternativeResolveEnabled(Runnable runnable) {
        this.setAlternativeResolveEnabled(true);
        try {
            runnable.run();
        }
        finally {
            this.setAlternativeResolveEnabled(false);
        }
    }

    public abstract boolean isAlternativeResolveEnabled();

    public static interface DumbModeListener {
        public void enteredDumbMode();

        public void exitDumbMode();
    }
}

