/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.fileEditor.UniqueVFilePathBuilder;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFilePathWrapper;
import javax.swing.JComponent;

public class ProjectUtil {
    private ProjectUtil() {
    }

    public static String getProjectLocationString(Project project) {
        return FileUtil.getLocationRelativeToUserHome((String)project.getBasePath());
    }

    public static String calcRelativeToProjectPath(VirtualFile file, Project project, boolean includeFilePath) {
        return ProjectUtil.calcRelativeToProjectPath(file, project, includeFilePath, false, false);
    }

    public static String calcRelativeToProjectPath(VirtualFile file, Project project, boolean includeFilePath, boolean includeUniqueFilePath, boolean keepModuleAlwaysOnTheLeft) {
        if (file instanceof VirtualFilePathWrapper && ((VirtualFilePathWrapper)((Object)file)).enforcePresentableName()) {
            return includeFilePath ? ((VirtualFilePathWrapper)((Object)file)).getPresentablePath() : file.getName();
        }
        String url = includeFilePath ? file.getPresentableUrl() : (includeUniqueFilePath ? UniqueVFilePathBuilder.getInstance().getUniqueVirtualFilePath(project, file) : file.getName());
        if (project == null) {
            return url;
        }
        return ProjectUtilCore.displayUrlRelativeToProject(file, url, project, includeFilePath, keepModuleAlwaysOnTheLeft);
    }

    public static String calcRelativeToProjectPath(VirtualFile file, Project project) {
        return ProjectUtil.calcRelativeToProjectPath(file, project, true);
    }

    public static Project guessProjectForFile(VirtualFile file) {
        return ProjectLocator.getInstance().guessProjectForFile(file);
    }

    public static Project guessProjectForContentFile(VirtualFile file) {
        return ProjectUtil.guessProjectForContentFile(file, file.getFileType());
    }

    public static Project guessProjectForContentFile(VirtualFile file, FileType fileType) {
        if (ProjectUtil.isProjectOrWorkspaceFile(file, fileType)) {
            return null;
        }
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            if (project.isDefault() || !project.isInitialized() || project.isDisposed() || !ProjectRootManager.getInstance(project).getFileIndex().isInContent(file)) continue;
            return project;
        }
        return null;
    }

    public static boolean isProjectOrWorkspaceFile(VirtualFile file) {
        return ProjectUtil.isProjectOrWorkspaceFile(file, FileTypeManager.getInstance().getFileTypeByFileName(file.getName()));
    }

    public static boolean isProjectOrWorkspaceFile(VirtualFile file, FileType fileType) {
        return ProjectCoreUtil.isProjectOrWorkspaceFile(file, fileType);
    }

    public static Project guessCurrentProject(JComponent component) {
        Project project = null;
        if (component != null) {
            project = CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext(component));
        }
        if (project == null) {
            Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
            if (openProjects.length > 0) {
                project = openProjects[0];
            }
            if (project == null) {
                DataContext dataContext = DataManager.getInstance().getDataContext();
                project = CommonDataKeys.PROJECT.getData(dataContext);
            }
            if (project == null) {
                project = ProjectManager.getInstance().getDefaultProject();
            }
        }
        return project;
    }
}

