/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.IconUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public abstract class SdkType
implements SdkTypeId {
    public static ExtensionPointName<SdkType> EP_NAME = ExtensionPointName.create((String)"com.intellij.sdkType");
    private final String myName;

    public abstract String suggestHomePath();

    public Collection<String> suggestHomePaths() {
        String s = this.suggestHomePath();
        return s == null ? Collections.emptyList() : Collections.singletonList(s);
    }

    public String adjustSelectedSdkHome(String homePath) {
        return homePath;
    }

    public abstract boolean isValidSdkHome(String var1);

    @Override
    public String getVersionString(Sdk sdk) {
        return this.getVersionString(sdk.getHomePath());
    }

    public String getVersionString(String sdkHome) {
        return null;
    }

    public abstract String suggestSdkName(String var1, String var2);

    public void setupSdkPaths(Sdk sdk) {
    }

    public boolean setupSdkPaths(Sdk sdk, SdkModel sdkModel) {
        this.setupSdkPaths(sdk);
        return true;
    }

    public abstract AdditionalDataConfigurable createAdditionalDataConfigurable(SdkModel var1, SdkModificator var2);

    public SdkAdditionalData loadAdditionalData(Element additional) {
        return null;
    }

    @Override
    public SdkAdditionalData loadAdditionalData(Sdk currentSdk, Element additional) {
        return this.loadAdditionalData(additional);
    }

    public SdkType(@NonNls String name) {
        this.myName = name;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    public abstract String getPresentableName();

    public Icon getIcon() {
        return null;
    }

    @NonNls
    public String getHelpTopic() {
        return "preferences.jdks";
    }

    public Icon getIconForAddAction() {
        return IconUtil.getAddIcon();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SdkType)) {
            return false;
        }
        SdkType sdkType = (SdkType)o;
        return this.myName.equals(sdkType.myName);
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    public String toString() {
        return this.getName();
    }

    public FileChooserDescriptor getHomeChooserDescriptor() {
        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, false, false, false, false){

            @Override
            public void validateSelectedFiles(VirtualFile[] files) throws Exception {
                String selectedPath;
                boolean valid;
                if (files.length != 0 && !(valid = SdkType.this.isValidSdkHome(selectedPath = files[0].getPath())) && !(valid = SdkType.this.isValidSdkHome(SdkType.this.adjustSelectedSdkHome(selectedPath)))) {
                    String message = files[0].isDirectory() ? ProjectBundle.message("sdk.configure.home.invalid.error", SdkType.this.getPresentableName()) : ProjectBundle.message("sdk.configure.home.file.invalid.error", SdkType.this.getPresentableName());
                    throw new Exception(message);
                }
            }
        };
        descriptor.setTitle(ProjectBundle.message("sdk.configure.home.title", this.getPresentableName()));
        return descriptor;
    }

    public String getHomeFieldLabel() {
        return ProjectBundle.message("sdk.configure.type.home.path", this.getPresentableName());
    }

    public String getDefaultDocumentationUrl(Sdk sdk) {
        return null;
    }

    public static SdkType[] getAllTypes() {
        ArrayList allTypes = new ArrayList();
        Collections.addAll(allTypes, ApplicationManager.getApplication().getComponents(SdkType.class));
        Collections.addAll(allTypes, Extensions.getExtensions(EP_NAME));
        return allTypes.toArray(new SdkType[allTypes.size()]);
    }

    public static <T extends SdkType> T findInstance(Class<T> sdkTypeClass) {
        for (SdkType sdkType : (SdkType[])Extensions.getExtensions(EP_NAME)) {
            if (!sdkTypeClass.equals(sdkType.getClass())) continue;
            return (T)sdkType;
        }
        assert (false);
        return null;
    }

    public boolean isRootTypeApplicable(OrderRootType type) {
        return true;
    }

    public boolean supportsCustomCreateUI() {
        return false;
    }

    public void showCustomCreateUI(SdkModel sdkModel, JComponent parentComponent, Consumer<Sdk> sdkCreatedCallback) {
    }

    public boolean sdkHasValidPath(Sdk sdk) {
        VirtualFile homeDir = sdk.getHomeDirectory();
        return homeDir != null && homeDir.isValid();
    }

    public String sdkPath(VirtualFile homePath) {
        return homePath.getPath();
    }
}

