/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.ui;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.ui.PathEditor;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.util.containers.ContainerUtil;

public class SdkPathEditor
extends PathEditor {
    private final String myDisplayName;
    private final OrderRootType myOrderRootType;

    public SdkPathEditor(String displayName, OrderRootType orderRootType, FileChooserDescriptor descriptor) {
        super(descriptor);
        this.myDisplayName = displayName;
        this.myOrderRootType = orderRootType;
    }

    public String getDisplayName() {
        return this.myDisplayName;
    }

    public OrderRootType getOrderRootType() {
        return this.myOrderRootType;
    }

    public void apply(SdkModificator sdkModificator) {
        sdkModificator.removeRoots(this.myOrderRootType);
        for (int i = 0; i < this.getRowCount(); ++i) {
            sdkModificator.addRoot(this.getValueAt(i), this.myOrderRootType);
        }
        this.setModified(false);
    }

    public void reset(SdkModificator modificator) {
        if (modificator != null) {
            this.resetPath(ContainerUtil.newArrayList((Object[])modificator.getRoots(this.myOrderRootType)));
        } else {
            this.setEnabled(false);
        }
    }
}

