/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import org.jdom.Element;

public enum DependencyScope {
    COMPILE("Compile", true, true, true, true),
    TEST("Test", false, false, true, true),
    RUNTIME("Runtime", false, true, false, true),
    PROVIDED("Provided", true, false, true, true);

    private final String myDisplayName;
    private final boolean myForProductionCompile;
    private final boolean myForProductionRuntime;
    private final boolean myForTestCompile;
    private final boolean myForTestRuntime;
    public static final String SCOPE_ATTR = "scope";

    private DependencyScope(String displayName, boolean forProductionCompile, boolean forProductionRuntime, boolean forTestCompile, boolean forTestRuntime) {
        this.myDisplayName = displayName;
        this.myForProductionCompile = forProductionCompile;
        this.myForProductionRuntime = forProductionRuntime;
        this.myForTestCompile = forTestCompile;
        this.myForTestRuntime = forTestRuntime;
    }

    public static DependencyScope readExternal(Element element) {
        String scope = element.getAttributeValue(SCOPE_ATTR);
        if (scope != null) {
            try {
                return DependencyScope.valueOf(scope);
            }
            catch (IllegalArgumentException e) {
                return COMPILE;
            }
        }
        return COMPILE;
    }

    public void writeExternal(Element element) {
        if (this != COMPILE) {
            element.setAttribute(SCOPE_ATTR, this.name());
        }
    }

    public String getDisplayName() {
        return this.myDisplayName;
    }

    public boolean isForProductionCompile() {
        return this.myForProductionCompile;
    }

    public boolean isForProductionRuntime() {
        return this.myForProductionRuntime;
    }

    public boolean isForTestCompile() {
        return this.myForTestCompile;
    }

    public boolean isForTestRuntime() {
        return this.myForTestRuntime;
    }

    public String toString() {
        return this.myDisplayName;
    }
}

