/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.util;

import com.intellij.openapi.roots.ui.ModifiableCellAppearanceEx;
import com.intellij.ui.HtmlListCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import javax.swing.Icon;

public class SimpleTextCellAppearance
implements ModifiableCellAppearanceEx {
    private Icon myIcon;
    private final SimpleTextAttributes myTextAttributes;
    private final String myText;

    public static SimpleTextCellAppearance regular(String text, Icon icon) {
        return new SimpleTextCellAppearance(text, icon, SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    public static SimpleTextCellAppearance invalid(String text, Icon icon) {
        return new SimpleTextCellAppearance(text, icon, SimpleTextAttributes.ERROR_ATTRIBUTES);
    }

    public static SimpleTextCellAppearance synthetic(String text, Icon icon) {
        return new SimpleTextCellAppearance(text, icon, SimpleTextAttributes.SYNTHETIC_ATTRIBUTES);
    }

    public SimpleTextCellAppearance(String text, Icon icon, SimpleTextAttributes textAttributes) {
        this.myIcon = icon;
        this.myTextAttributes = textAttributes;
        this.myText = text;
    }

    @Override
    public void customize(SimpleColoredComponent component) {
        component.setIcon(this.myIcon);
        component.append(this.myText, this.myTextAttributes);
    }

    @Override
    public void customize(HtmlListCellRenderer renderer) {
        renderer.setIcon(this.myIcon);
        renderer.append(this.myText, this.myTextAttributes);
    }

    @Override
    public String getText() {
        return this.myText;
    }

    public SimpleTextAttributes getTextAttributes() {
        return this.myTextAttributes;
    }

    @Override
    public void setIcon(Icon icon) {
        this.myIcon = icon;
    }
}

