/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.actionSystem.ActionGroup;
import javax.swing.JComponent;

public interface ComponentWithActions {
    public ActionGroup getToolbarActions();

    public JComponent getSearchComponent();

    public String getToolbarPlace();

    public JComponent getToolbarContextComponent();

    public JComponent getComponent();

    public boolean isContentBuiltIn();

    public static class Impl
    implements ComponentWithActions {
        private final ActionGroup myToolbar;
        private final String myToolbarPlace;
        private final JComponent myToolbarContext;
        private final JComponent mySearchComponent;
        private final JComponent myComponent;

        public Impl(ActionGroup toolbar, String toolbarPlace, JComponent toolbarContext, JComponent searchComponent, JComponent component) {
            this.myToolbar = toolbar;
            this.myToolbarPlace = toolbarPlace;
            this.myToolbarContext = toolbarContext;
            this.mySearchComponent = searchComponent;
            this.myComponent = component;
        }

        @Override
        public boolean isContentBuiltIn() {
            return false;
        }

        public Impl(JComponent component) {
            this(null, null, null, null, component);
        }

        @Override
        public ActionGroup getToolbarActions() {
            return this.myToolbar;
        }

        @Override
        public JComponent getSearchComponent() {
            return this.mySearchComponent;
        }

        @Override
        public String getToolbarPlace() {
            return this.myToolbarPlace;
        }

        @Override
        public JComponent getToolbarContextComponent() {
            return this.myToolbarContext;
        }

        @Override
        public JComponent getComponent() {
            return this.myComponent;
        }
    }
}

