/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Banner;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.ui.NullableComponent;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class DetailsComponent {
    private final JPanel myComponent;
    private JComponent myContent;
    private final Banner myBannerLabel;
    private final JLabel myEmptyContentLabel;
    private final NonOpaquePanel myBanner;
    private String[] myBannerText;
    private boolean myDetailsEnabled;
    private String[] myPrefix;
    private String[] myText;
    private final Wrapper myContentGutter = new Wrapper();
    private boolean myPaintBorder;

    public DetailsComponent() {
        this(true, true);
    }

    public DetailsComponent(boolean detailsEnabled, boolean paintBorder) {
        this.myDetailsEnabled = detailsEnabled;
        this.myPaintBorder = paintBorder;
        this.myComponent = new JPanel(new BorderLayout()){

            @Override
            protected void paintComponent(Graphics g) {
                if (NullableComponent.Check.isNull((Component)DetailsComponent.this.myContent) || !DetailsComponent.this.myDetailsEnabled) {
                    return;
                }
                GraphicsConfig c = null;
                Insets insets = null;
                if (!Registry.is((String)"ide.new.settings.dialog")) {
                    c = new GraphicsConfig(g);
                    c.setAntialiasing(true);
                    insets = this.getInsets();
                    if (insets == null) {
                        insets = new Insets(0, 0, 0, 0);
                    }
                    g.setColor(UIUtil.getFocusedFillColor());
                    Rectangle banner = DetailsComponent.this.myBanner.getBounds();
                    GeneralPath header = new GeneralPath();
                    int leftX = insets.left;
                    int leftY = insets.top;
                    int rightX = insets.left + this.getWidth() - 1 - insets.right;
                    int rightY = banner.y + banner.height;
                    header.moveTo(leftX, rightY);
                    int arc = 8;
                    header.lineTo(leftX, leftY + arc);
                    header.quadTo(leftX, leftY, leftX + arc, leftY);
                    header.lineTo(rightX - arc, leftY);
                    header.quadTo(rightX, leftY, rightX, leftY + arc);
                    header.lineTo(rightX, rightY);
                    header.closePath();
                    c.getG().fill(header);
                    g.setColor(UIUtil.getFocusedBoundsColor());
                    c.getG().draw(header);
                    if (DetailsComponent.this.myPaintBorder) {
                        int down = this.getHeight() - insets.top - insets.bottom - 1;
                        g.drawLine(leftX, rightY, leftX, down);
                        g.drawLine(rightX, rightY, rightX, down);
                        g.drawLine(leftX, down, rightX, down);
                    }
                    c.restore();
                }
            }
        };
        this.myComponent.setOpaque(false);
        this.myContentGutter.setOpaque(false);
        this.myContentGutter.setBorder(null);
        this.myBanner = new NonOpaquePanel(new BorderLayout());
        this.myBannerLabel = new Banner();
        if (this.myDetailsEnabled) {
            this.myBanner.add((Component)this.myBannerLabel, "Center");
        }
        this.myEmptyContentLabel = new JLabel("", 0);
        this.revalidateDetailsMode();
    }

    private void revalidateDetailsMode() {
        this.myComponent.removeAll();
        this.myComponent.add((Component)this.myContentGutter, "Center");
        if (this.myDetailsEnabled) {
            this.myComponent.add((Component)this.myBanner, "North");
        }
        if (this.myContent != null) {
            this.myContentGutter.add((Component)this.myContent, "Center");
            this.invalidateContentBorder();
        }
        this.myComponent.revalidate();
        this.myComponent.repaint();
    }

    public void setBannerActions(Action[] actions) {
        this.myBannerLabel.clearActions();
        for (Action each : actions) {
            this.myBannerLabel.addAction(each);
        }
        this.myComponent.revalidate();
        this.myComponent.repaint();
    }

    public void setContent(JComponent c) {
        if (this.myContent != null) {
            this.myContentGutter.remove(this.myContent);
        }
        this.myContent = new MyWrapper(c);
        this.myContent.setOpaque(false);
        this.invalidateContentBorder();
        this.myContentGutter.add((Component)this.myContent, "Center");
        this.updateBanner();
        this.myComponent.revalidate();
        this.myComponent.repaint();
    }

    private void invalidateContentBorder() {
        if (this.myDetailsEnabled) {
            this.myContent.setBorder(new EmptyBorder(UIUtil.PANEL_REGULAR_INSETS));
        } else {
            this.myContent.setBorder(null);
        }
    }

    public void forProject(Project project) {
        this.myBannerLabel.forProject(project);
    }

    public void setPrefix(String ... prefix) {
        this.myPrefix = prefix;
        if (this.myText != null) {
            this.setText(this.myText);
        }
    }

    public void setText(String ... text) {
        this.myText = text;
        this.update();
    }

    public void update() {
        ArrayList strings = new ArrayList();
        if (this.myPrefix != null) {
            ContainerUtil.addAll(strings, (Object[])this.myPrefix);
        }
        if (this.myText != null) {
            ContainerUtil.addAll(strings, (Object[])this.myText);
        }
        this.myBannerText = ArrayUtil.toStringArray(strings);
        this.updateBanner();
    }

    private void updateBanner() {
        this.myBannerLabel.setText(NullableComponent.Check.isNull((Component)this.myContent) || this.myBannerText == null ? ArrayUtil.EMPTY_STRING_ARRAY : this.myBannerText);
        this.myBannerLabel.revalidate();
        this.myBannerLabel.repaint();
    }

    public void setPaintBorder(boolean paintBorder) {
        this.myPaintBorder = paintBorder;
    }

    public DetailsComponent setEmptyContentText(String emptyContentText) {
        String s = XmlStringUtil.wrapInHtml((CharSequence)("<center>" + (emptyContentText != null ? emptyContentText : "") + "</center>"));
        this.myEmptyContentLabel.setText(s);
        return this;
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    public JComponent getContentGutter() {
        return this.myContentGutter;
    }

    public void setBannerMinHeight(int height) {
        this.myBannerLabel.setMinHeight(height);
    }

    public void disposeUIResources() {
        this.setContent(null);
    }

    public void updateBannerActions() {
        this.myBannerLabel.updateActions();
    }

    public void setDetailsModeEnabled(boolean enabled) {
        if (this.myDetailsEnabled == enabled) {
            return;
        }
        this.myDetailsEnabled = enabled;
        this.revalidateDetailsMode();
    }

    private class MyWrapper
    extends Wrapper
    implements NullableComponent {
        public MyWrapper(JComponent c) {
            super(c == null || NullableComponent.Check.isNull((Component)c) ? DetailsComponent.this.myEmptyContentLabel : c);
        }

        @Override
        public boolean isNull() {
            return this.getTargetComponent() == DetailsComponent.this.myEmptyContentLabel;
        }
    }

    public static interface Facade {
        public DetailsComponent getDetailsComponent();
    }
}

