/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.CommonBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;

public class DialogBuilder
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.ui.DialogBuilder");
    @NonNls
    public static final String REQUEST_FOCUS_ENABLED = "requestFocusEnabled";
    private JComponent myCenterPanel;
    private JComponent myNorthPanel;
    private String myTitle;
    private JComponent myPreferedFocusComponent;
    private String myDimensionServiceKey;
    private ArrayList<ActionDescriptor> myActions = null;
    private final MyDialogWrapper myDialogWrapper;
    private Runnable myCancelOperation = null;
    private Runnable myOkOperation = null;

    public int show() {
        return this.showImpl(true).getExitCode();
    }

    public boolean showAndGet() {
        return this.showImpl(true).isOK();
    }

    public void showNotModal() {
        this.showImpl(false);
    }

    public DialogBuilder(Project project) {
        this.myDialogWrapper = new MyDialogWrapper(project, true);
        Disposer.register((Disposable)this.myDialogWrapper.getDisposable(), (Disposable)this);
    }

    public DialogBuilder(Component parent) {
        this.myDialogWrapper = new MyDialogWrapper(parent, true);
        Disposer.register((Disposable)this.myDialogWrapper.getDisposable(), (Disposable)this);
    }

    public DialogBuilder() {
        this((Project)null);
    }

    public void dispose() {
    }

    private MyDialogWrapper showImpl(boolean isModal) {
        LOG.assertTrue(!StringUtil.isEmptyOrSpaces((String)this.myTitle), (Object)String.format("Dialog title shouldn't be empty or null: [%s]", this.myTitle));
        this.myDialogWrapper.setTitle(this.myTitle);
        this.myDialogWrapper.init();
        this.myDialogWrapper.setModal(isModal);
        this.myDialogWrapper.show();
        if (isModal) {
            this.myDialogWrapper.dispose();
        }
        return this.myDialogWrapper;
    }

    public void setCenterPanel(JComponent centerPanel) {
        this.myCenterPanel = centerPanel;
    }

    public DialogBuilder centerPanel(JComponent centerPanel) {
        this.myCenterPanel = centerPanel;
        return this;
    }

    public DialogBuilder setNorthPanel(JComponent northPanel) {
        this.myNorthPanel = northPanel;
        return this;
    }

    public void setTitle(String title) {
        this.myTitle = title;
    }

    public DialogBuilder title(String title) {
        this.myTitle = title;
        return this;
    }

    public void setPreferredFocusComponent(JComponent component) {
        this.myPreferedFocusComponent = component;
    }

    public void setDimensionServiceKey(@NonNls String dimensionServiceKey) {
        this.myDimensionServiceKey = dimensionServiceKey;
    }

    public DialogBuilder dimensionKey(String dimensionServiceKey) {
        this.myDimensionServiceKey = dimensionServiceKey;
        return this;
    }

    public void addAction(Action action) {
        this.addActionDescriptor(new CustomActionDescriptor(action));
    }

    public <T extends ActionDescriptor> T addActionDescriptor(T actionDescriptor) {
        this.getActionDescriptors().add(actionDescriptor);
        return actionDescriptor;
    }

    private ArrayList<ActionDescriptor> getActionDescriptors() {
        if (this.myActions == null) {
            this.removeAllActions();
        }
        return this.myActions;
    }

    public void setActionDescriptors(ActionDescriptor[] descriptors) {
        this.removeAllActions();
        ContainerUtil.addAll(this.myActions, (Object[])descriptors);
    }

    public void removeAllActions() {
        this.myActions = new ArrayList();
    }

    public Window getWindow() {
        return this.myDialogWrapper.getWindow();
    }

    public CustomizableAction addOkAction() {
        return this.addActionDescriptor(new OkActionDescriptor());
    }

    public CustomizableAction addCancelAction() {
        return this.addActionDescriptor(new CancelActionDescriptor());
    }

    public CustomizableAction addCloseButton() {
        CustomizableAction closeAction = this.addOkAction();
        closeAction.setText(CommonBundle.getCloseButtonText());
        return closeAction;
    }

    public void addDisposable(Disposable disposable) {
        Disposer.register((Disposable)this, (Disposable)disposable);
    }

    public void setButtonsAlignment(int alignment) {
        this.myDialogWrapper.setButtonsAlignment(alignment);
    }

    public DialogWrapper getDialogWrapper() {
        return this.myDialogWrapper;
    }

    public void showModal(boolean modal) {
        if (modal) {
            this.show();
        } else {
            this.showNotModal();
        }
    }

    public void setHelpId(@NonNls String helpId) {
        this.myDialogWrapper.setHelpId(helpId);
    }

    public void setCancelOperation(Runnable runnable) {
        this.myCancelOperation = runnable;
    }

    public void setOkOperation(Runnable runnable) {
        this.myOkOperation = runnable;
    }

    public void setOkActionEnabled(boolean isEnabled) {
        this.myDialogWrapper.setOKActionEnabled(isEnabled);
    }

    public DialogBuilder okActionEnabled(boolean isEnabled) {
        this.myDialogWrapper.setOKActionEnabled(isEnabled);
        return this;
    }

    public DialogBuilder resizable(boolean resizable) {
        this.myDialogWrapper.setResizable(resizable);
        return this;
    }

    public CustomizableAction getOkAction() {
        return DialogBuilder.get(this.getActionDescriptors(), OkActionDescriptor.class);
    }

    private static CustomizableAction get(ArrayList<ActionDescriptor> actionDescriptors, Class aClass) {
        for (ActionDescriptor actionDescriptor : actionDescriptors) {
            if (!actionDescriptor.getClass().isAssignableFrom(aClass)) continue;
            return (CustomizableAction)((Object)actionDescriptor);
        }
        return null;
    }

    public CustomizableAction getCancelAction() {
        return DialogBuilder.get(this.getActionDescriptors(), CancelActionDescriptor.class);
    }

    public Component getCenterPanel() {
        return this.myCenterPanel;
    }

    public void setErrorText(String text) {
        this.myDialogWrapper.setErrorText(text);
    }

    private class MyDialogWrapper
    extends DialogWrapper {
        private String myHelpId;

        private MyDialogWrapper(Project project, boolean canBeParent) {
            super(project, canBeParent);
            this.myHelpId = null;
        }

        private MyDialogWrapper(Component parent, boolean canBeParent) {
            super(parent, canBeParent);
            this.myHelpId = null;
        }

        public void setHelpId(String helpId) {
            this.myHelpId = helpId;
        }

        @Override
        protected String getHelpId() {
            return this.myHelpId;
        }

        @Override
        public void init() {
            super.init();
        }

        @Override
        public Action getOKAction() {
            return super.getOKAction();
        }

        @Override
        public Action getCancelAction() {
            return super.getCancelAction();
        }

        @Override
        protected JComponent createCenterPanel() {
            return DialogBuilder.this.myCenterPanel;
        }

        @Override
        protected JComponent createNorthPanel() {
            return DialogBuilder.this.myNorthPanel;
        }

        @Override
        public void dispose() {
            DialogBuilder.this.myPreferedFocusComponent = null;
            super.dispose();
        }

        @Override
        public JComponent getPreferredFocusedComponent() {
            if (DialogBuilder.this.myPreferedFocusComponent != null) {
                return DialogBuilder.this.myPreferedFocusComponent;
            }
            FocusTraversalPolicy focusTraversalPolicy = null;
            for (Container container = DialogBuilder.this.myCenterPanel; container != null && (focusTraversalPolicy = container.getFocusTraversalPolicy()) == null && !(container instanceof Window); container = container.getParent()) {
            }
            if (focusTraversalPolicy == null) {
                return null;
            }
            Component component = focusTraversalPolicy.getDefaultComponent(DialogBuilder.this.myCenterPanel);
            while (!(component instanceof JComponent) && component != null) {
                component = focusTraversalPolicy.getComponentAfter(DialogBuilder.this.myCenterPanel, component);
            }
            return (JComponent)component;
        }

        @Override
        protected String getDimensionServiceKey() {
            return DialogBuilder.this.myDimensionServiceKey;
        }

        @Override
        protected JButton createJButtonForAction(Action action) {
            JButton button = super.createJButtonForAction(action);
            Object value = action.getValue(DialogBuilder.REQUEST_FOCUS_ENABLED);
            if (value instanceof Boolean) {
                button.setRequestFocusEnabled((Boolean)value);
            }
            return button;
        }

        @Override
        public void doCancelAction() {
            if (!this.getCancelAction().isEnabled()) {
                return;
            }
            if (DialogBuilder.this.myCancelOperation != null) {
                DialogBuilder.this.myCancelOperation.run();
            } else {
                super.doCancelAction();
            }
        }

        @Override
        protected void doOKAction() {
            if (DialogBuilder.this.myOkOperation != null) {
                DialogBuilder.this.myOkOperation.run();
            } else {
                super.doOKAction();
            }
        }

        @Override
        protected void doHelpAction() {
            if (this.myHelpId == null) {
                super.doHelpAction();
                return;
            }
            HelpManager.getInstance().invokeHelp(this.myHelpId);
        }

        @Override
        protected Action[] createActions() {
            if (DialogBuilder.this.myActions == null) {
                return super.createActions();
            }
            ArrayList<Action> actions = new ArrayList<Action>(DialogBuilder.this.myActions.size());
            for (ActionDescriptor actionDescriptor : DialogBuilder.this.myActions) {
                actions.add(actionDescriptor.getAction(this));
            }
            if (this.myHelpId != null) {
                actions.add(this.getHelpAction());
            }
            return actions.toArray(new Action[actions.size()]);
        }
    }

    public static class CancelActionDescriptor
    extends BuiltinAction {
        @Override
        protected Action getBuiltinAction(MyDialogWrapper dialogWrapper) {
            return dialogWrapper.getCancelAction();
        }
    }

    public static class OkActionDescriptor
    extends BuiltinAction {
        @Override
        protected Action getBuiltinAction(MyDialogWrapper dialogWrapper) {
            return dialogWrapper.getOKAction();
        }
    }

    private static abstract class BuiltinAction
    implements ActionDescriptor,
    CustomizableAction {
        protected String myText = null;

        private BuiltinAction() {
        }

        @Override
        public void setText(String text) {
            this.myText = text;
        }

        @Override
        public Action getAction(DialogWrapper dialogWrapper) {
            Action builtinAction = this.getBuiltinAction((MyDialogWrapper)dialogWrapper);
            if (this.myText != null) {
                builtinAction.putValue("Name", this.myText);
            }
            return builtinAction;
        }

        protected abstract Action getBuiltinAction(MyDialogWrapper var1);
    }

    public static class CustomActionDescriptor
    implements ActionDescriptor {
        private final Action myAction;

        public CustomActionDescriptor(Action action) {
            this.myAction = action;
        }

        @Override
        public Action getAction(DialogWrapper dialogWrapper) {
            return this.myAction;
        }
    }

    public static interface CustomizableAction {
        public void setText(String var1);
    }

    public static class CloseDialogAction
    extends DialogActionDescriptor {
        private final int myExitCode;

        public CloseDialogAction() {
            this(CommonBundle.getCloseButtonText(), -1, 1);
        }

        public CloseDialogAction(String name, int mnemonicChar, int exitCode) {
            super(name, mnemonicChar);
            this.myExitCode = exitCode;
        }

        public static CloseDialogAction createDefault(String name, int mnemonicChar, int exitCode) {
            CloseDialogAction closeDialogAction = new CloseDialogAction(name, mnemonicChar, exitCode);
            closeDialogAction.setDefault(true);
            return closeDialogAction;
        }

        @Override
        protected Action createAction(final DialogWrapper dialogWrapper) {
            return new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    dialogWrapper.close(CloseDialogAction.this.myExitCode);
                }
            };
        }
    }

    public static abstract class DialogActionDescriptor
    implements ActionDescriptor {
        private final String myName;
        private final Object myMnemonicChar;
        private boolean myIsDefault = false;

        protected DialogActionDescriptor(String name, int mnemonicChar) {
            this.myName = name;
            this.myMnemonicChar = mnemonicChar == -1 ? null : Integer.valueOf(mnemonicChar);
        }

        @Override
        public Action getAction(DialogWrapper dialogWrapper) {
            Action action = this.createAction(dialogWrapper);
            action.putValue("Name", this.myName);
            if (this.myMnemonicChar != null) {
                action.putValue("MnemonicKey", this.myMnemonicChar);
            }
            if (this.myIsDefault) {
                action.putValue("Default", Boolean.TRUE);
            }
            return action;
        }

        public void setDefault(boolean isDefault) {
            this.myIsDefault = isDefault;
        }

        protected abstract Action createAction(DialogWrapper var1);
    }

    public static interface ActionDescriptor {
        public Action getAction(DialogWrapper var1);
    }
}

