/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.MasterDetailsState;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

@State(name="masterDetails", storages={@Storage(file="$WORKSPACE_FILE$")})
public class MasterDetailsStateService
implements PersistentStateComponent<States> {
    private final SkipDefaultValuesSerializationFilters mySerializationFilter = new SkipDefaultValuesSerializationFilters();
    private final Map<String, ComponentState> myStates = new HashMap<String, ComponentState>();

    public static MasterDetailsStateService getInstance(Project project) {
        return ServiceManager.getService(project, MasterDetailsStateService.class);
    }

    public void register(String key, MasterDetailsComponent component) {
    }

    public MasterDetailsState getComponentState(@NonNls String key, Class<? extends MasterDetailsState> stateClass) {
        ComponentState state = this.myStates.get(key);
        if (state == null) {
            return null;
        }
        Element settings = state.mySettings;
        return settings != null ? (MasterDetailsState)XmlSerializer.deserialize((Element)settings, stateClass) : null;
    }

    public void setComponentState(@NonNls String key, MasterDetailsState state) {
        Element element = XmlSerializer.serialize((Object)state, (SerializationFilter)this.mySerializationFilter);
        if (element == null) {
            this.myStates.remove(key);
        } else {
            ComponentState componentState = new ComponentState();
            componentState.myKey = key;
            componentState.mySettings = element;
            this.myStates.put(key, componentState);
        }
    }

    @Override
    public States getState() {
        States states = new States();
        states.myStates.addAll(this.myStates.values());
        Collections.sort(states.getStates(), new Comparator<ComponentState>(){

            @Override
            public int compare(ComponentState o1, ComponentState o2) {
                return o1.myKey.compareTo(o2.myKey);
            }
        });
        return states;
    }

    @Override
    public void loadState(States states) {
        this.myStates.clear();
        for (ComponentState state : states.getStates()) {
            this.myStates.put(state.myKey, state);
        }
    }

    public static class States {
        private List<ComponentState> myStates = new ArrayList<ComponentState>();

        @Tag(value="states")
        @AbstractCollection(surroundWithTag=false)
        public List<ComponentState> getStates() {
            return this.myStates;
        }

        public void setStates(List<ComponentState> states) {
            this.myStates = states;
        }
    }

    @Tag(value="state")
    public static class ComponentState {
        @Attribute(value="key")
        public String myKey;
        @Tag(value="settings")
        public Element mySettings;
    }
}

