/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.popup.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.lang.reflect.Method;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.ComboPopup;

public class PopupUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.ui.popup.util.PopupUtil");

    private PopupUtil() {
    }

    public static Component getOwner(Component c) {
        if (c == null) {
            return null;
        }
        Window wnd = SwingUtilities.getWindowAncestor(c);
        if (wnd instanceof JWindow) {
            JRootPane root = ((JWindow)wnd).getRootPane();
            JBPopup popup = (JBPopup)root.getClientProperty("JBPopup");
            if (popup == null) {
                return c;
            }
            Component owner = popup.getOwner();
            if (owner == null) {
                return c;
            }
            return PopupUtil.getOwner(owner);
        }
        return c;
    }

    public static JBPopup getPopupContainerFor(Component c) {
        if (c == null) {
            return null;
        }
        Window wnd = SwingUtilities.getWindowAncestor(c);
        if (wnd instanceof JWindow) {
            JRootPane root = ((JWindow)wnd).getRootPane();
            return (JBPopup)root.getClientProperty("JBPopup");
        }
        return null;
    }

    public static void setPopupType(PopupFactory factory, int type) {
        try {
            Method method = PopupFactory.class.getDeclaredMethod("setPopupType", Integer.TYPE);
            method.setAccessible(true);
            method.invoke((Object)factory, type);
        }
        catch (Throwable e) {
            LOG.error(e);
        }
    }

    public static int getPopupType(PopupFactory factory) {
        try {
            Method method = PopupFactory.class.getDeclaredMethod("getPopupType", new Class[0]);
            method.setAccessible(true);
            Object result = method.invoke((Object)factory, new Object[0]);
            return result instanceof Integer ? (Integer)result : -1;
        }
        catch (Throwable e) {
            LOG.error(e);
            return -1;
        }
    }

    public static Component getActiveComponent() {
        Window[] windows;
        for (Window each : windows = Window.getWindows()) {
            if (!each.isActive()) continue;
            return each;
        }
        IdeFrame frame = IdeFocusManager.findInstance().getLastFocusedFrame();
        if (frame != null) {
            return frame.getComponent();
        }
        return JOptionPane.getRootFrame();
    }

    public static void showBalloonForActiveFrame(final String message, final MessageType type) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                IdeFrame frame = IdeFocusManager.findInstance().getLastFocusedFrame();
                if (frame == null) {
                    Project[] projects = ProjectManager.getInstance().getOpenProjects();
                    Project project = projects == null || projects.length == 0 ? ProjectManager.getInstance().getDefaultProject() : projects[0];
                    JFrame jFrame = WindowManager.getInstance().getFrame(project);
                    if (jFrame != null) {
                        PopupUtil.showBalloonForComponent(jFrame, message, type, true, project);
                    } else {
                        LOG.info("Can not get component to show message: " + message);
                    }
                    return;
                }
                PopupUtil.showBalloonForComponent(frame.getComponent(), message, type, true, frame.getProject());
            }
        };
        UIUtil.invokeLaterIfNeeded((Runnable)runnable);
    }

    public static void showBalloonForActiveComponent(final String message, final MessageType type) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Window[] windows = Window.getWindows();
                Window targetWindow = null;
                for (Window each : windows) {
                    if (!each.isActive()) continue;
                    targetWindow = each;
                    break;
                }
                if (targetWindow == null) {
                    targetWindow = JOptionPane.getRootFrame();
                }
                if (targetWindow == null) {
                    IdeFrame frame = IdeFocusManager.findInstance().getLastFocusedFrame();
                    if (frame == null) {
                        Project[] projects = ProjectManager.getInstance().getOpenProjects();
                        Project project = projects == null || projects.length == 0 ? ProjectManager.getInstance().getDefaultProject() : projects[0];
                        JFrame jFrame = WindowManager.getInstance().getFrame(project);
                        if (jFrame != null) {
                            PopupUtil.showBalloonForComponent(jFrame, message, type, true, project);
                        } else {
                            LOG.info("Can not get component to show message: " + message);
                        }
                        return;
                    }
                    PopupUtil.showBalloonForComponent(frame.getComponent(), message, type, true, frame.getProject());
                } else {
                    PopupUtil.showBalloonForComponent(targetWindow, message, type, true, null);
                }
            }
        };
        UIUtil.invokeLaterIfNeeded((Runnable)runnable);
    }

    public static void showBalloonForComponent(Component component, String message, MessageType type, boolean atTop, Disposable disposable) {
        Balloon.Position position;
        int x;
        int y;
        JBPopupFactory popupFactory = JBPopupFactory.getInstance();
        if (popupFactory == null) {
            return;
        }
        BalloonBuilder balloonBuilder = popupFactory.createHtmlTextBalloonBuilder(message, type, null);
        balloonBuilder.setDisposable(disposable == null ? ApplicationManager.getApplication() : disposable);
        Balloon balloon = balloonBuilder.createBalloon();
        Dimension size = component.getSize();
        if (size == null) {
            y = 0;
            x = 0;
            position = Balloon.Position.above;
        } else {
            x = Math.min(10, size.width / 2);
            y = size.height;
            position = Balloon.Position.below;
        }
        balloon.show(new RelativePoint(component, new Point(x, y)), position);
    }

    public static boolean isComboPopupKeyEvent(ComponentEvent event, JComboBox comboBox) {
        Component component = event.getComponent();
        if (!comboBox.isPopupVisible() || component == null) {
            return false;
        }
        ComboPopup popup = (ComboPopup)ReflectionUtil.getField(comboBox.getUI().getClass(), (Object)comboBox.getUI(), ComboPopup.class, (String)"popup");
        return popup != null && SwingUtilities.isDescendingFrom(popup.getList(), component);
    }
}

